/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.rest;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugin.devstatus.labs.PhaseTwoFeatureFlag;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderHelper;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.CachingProviderDecorator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.auth.OAuthRequestVerifierFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/webhooks")
@Produces(value={"text/plain"})
public class WebhooksResource {
    private final DataProviderHelper dataProviderHelper;
    private final OAuthRequestVerifierFactory oAuthRequestVerifierFactory;
    private final IssueManager issueManager;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PhaseTwoFeatureFlag phaseTwoFeatureFlag;
    private static final Logger logger = LoggerFactory.getLogger(WebhooksResource.class);

    public WebhooksResource(DataProviderHelper dataProviderHelper, @ComponentImport OAuthRequestVerifierFactory oAuthRequestVerifierFactory, @ComponentImport IssueManager issueManager, @ComponentImport FeatureManager featureManager, @ComponentImport JiraAuthenticationContext authenticationContext, PhaseTwoFeatureFlag phaseTwoFeatureFlag) {
        this.dataProviderHelper = dataProviderHelper;
        this.oAuthRequestVerifierFactory = oAuthRequestVerifierFactory;
        this.issueManager = issueManager;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
        this.phaseTwoFeatureFlag = phaseTwoFeatureFlag;
    }

    @POST
    @Path(value="/update-summary")
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    public Response getUpdateSummary(UpdateSummaryRequest request) {
        if (!this.phaseTwoFeatureFlag.isPhaseTwoEnabled()) {
            return PhaseTwoFeatureFlag.restResponse();
        }
        if (!(this.featureManager.isOnDemand() || !this.authenticationContext.isLoggedInUser() && this.oAuthRequestVerifierFactory.getInstance(null).isVerified())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        logger.trace("Got updated issue summaries from {}", (Object)request.sourceId);
        Option maybeProvider = this.dataProviderHelper.getFromId(request.sourceId).orElse(this.dataProviderHelper.getFromBaseUrl(request.sourceUrl));
        if (maybeProvider.isEmpty()) {
            logger.debug("Unknown Source ID in request: {}", (Object)request.sourceId);
        }
        Option fromId = maybeProvider.filter((Predicate)new Predicate<DataProvider>(){

            public boolean apply(@Nullable DataProvider input) {
                return input instanceof CachingProviderDecorator;
            }
        });
        final Set<IssueDataRequest> refreshIssueRequests = this.makeDevSummaryRequests(request.issueKeys);
        fromId.foreach((Effect)new Effect<DataProvider>(){

            public void apply(DataProvider dataProvider) {
                if (!refreshIssueRequests.isEmpty()) {
                    ((CachingProviderDecorator)dataProvider).refresh(refreshIssueRequests);
                }
            }
        });
        return Response.ok((Object)"OK").build();
    }

    private Set<IssueDataRequest> makeDevSummaryRequests(List<String> issueKeys) {
        HashSet requests = Sets.newHashSet();
        for (String key : issueKeys) {
            MutableIssue issue = this.issueManager.getIssueObject(key);
            if (issue == null) continue;
            Long issueId = issue.getId();
            requests.add(new IssueDataRequest(issueId, this.issueManager.getAllIssueKeys(issueId)));
        }
        return requests;
    }

    @XmlRootElement
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class UpdateSummaryRequest {
        @JsonProperty
        List<String> issueKeys;
        @JsonProperty
        String sourceId;
        @JsonProperty
        String sourceUrl;
    }
}

