/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderSource;
import com.atlassian.jira.plugin.devstatus.provider.source.DataProviderRemovalListener;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.BitbucketInfo;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsApplicationTypeInfo;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsDataProvider;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsFacade;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.GitHubEnterpriseInfo;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.GitHubInfo;
import com.atlassian.jira.plugin.devstatus.provider.spring.SpringUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DvcsProviderSource
implements DataProviderSource {
    private static final Logger logger = LoggerFactory.getLogger(DvcsProviderSource.class);
    private final DvcsFacade dvcsFacade;
    private final SpringUtil spring;
    private final Cache<DvcsFacade.DvcsApplicationType, DataProvider> dataProviderCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(new DataProviderRemovalListener()).build((CacheLoader)new DvcsDataProviderLoader());

    @Inject
    public DvcsProviderSource(DvcsFacade dvcsFacade, SpringUtil spring) {
        this.dvcsFacade = dvcsFacade;
        this.spring = spring;
    }

    @Override
    public ImmutableList<DataProvider> availableProviders() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DvcsFacade.DvcsApplicationType dvcsApplicationType : DvcsFacade.DvcsApplicationType.values()) {
            if (!this.dvcsFacade.hasDvcsAccounts(dvcsApplicationType)) {
                this.dataProviderCache.invalidate((Object)dvcsApplicationType);
                continue;
            }
            builder.add(this.dataProviderCache.getUnchecked((Object)dvcsApplicationType));
        }
        return builder.build();
    }

    private DvcsApplicationTypeInfo getDvcsDetails(DvcsFacade.DvcsApplicationType dvcsApplicationType) {
        switch (dvcsApplicationType) {
            case BITBUCKET: {
                return new BitbucketInfo();
            }
            case GITHUB: {
                return new GitHubInfo();
            }
            case GITHUB_ENTERPRISE: {
                return new GitHubEnterpriseInfo();
            }
        }
        throw new IllegalArgumentException("Unknown dvcs type " + (Object)((Object)dvcsApplicationType));
    }

    private class DvcsDataProviderLoader
    extends CacheLoader<DvcsFacade.DvcsApplicationType, DataProvider> {
        private DvcsDataProviderLoader() {
        }

        public DvcsDataProvider load(DvcsFacade.DvcsApplicationType dvcsApplicationType) throws Exception {
            DvcsDataProvider dvcsDataProvider = DvcsProviderSource.this.spring.createInstanceOf(DvcsDataProvider.class);
            dvcsDataProvider.init(DvcsProviderSource.this.getDvcsDetails(dvcsApplicationType));
            logger.debug("Created DataProvider: {}", (Object)dvcsDataProvider);
            return dvcsDataProvider;
        }
    }
}

