/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.fusion.schema.detail.BaseRepository;
import com.atlassian.fusion.schema.detail.commit.Commit;
import com.atlassian.fusion.schema.detail.commit.Committer;
import com.atlassian.fusion.schema.detail.commit.File;
import com.atlassian.fusion.schema.detail.commit.Repositories;
import com.atlassian.fusion.schema.detail.commit.Repository;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsChangesetServiceAccessor;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsRepositoryServiceAccessor;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.ChangesetDetailsFetcher;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsApplicationTypeInfo;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFile;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileAction;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetail;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsChangesetService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsRepositoryService;
import com.atlassian.jira.util.UrlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DvcsCommitDetailHelper {
    private static final Logger logger = LoggerFactory.getLogger(DvcsCommitDetailHelper.class);
    private final DvcsChangesetServiceAccessor changesetServiceAccessor;
    private final DvcsRepositoryServiceAccessor repositoryService;
    private final ChangesetDetailsFetcher changesetDetailsFetcher;

    public DvcsCommitDetailHelper(DvcsChangesetServiceAccessor changesetServiceAccessor, DvcsRepositoryServiceAccessor repositoryService, ChangesetDetailsFetcher changesetDetailsFetcher) {
        this.changesetServiceAccessor = changesetServiceAccessor;
        this.repositoryService = repositoryService;
        this.changesetDetailsFetcher = changesetDetailsFetcher;
    }

    @VisibleForTesting
    Repositories getCommitInfoMappedByRepository(Set<String> issueKeys, DvcsApplicationTypeInfo dvcsApplicationTypeInfo, ExecutorService executorService) {
        DvcsChangesetService service = (DvcsChangesetService)this.changesetServiceAccessor.getService();
        DvcsRepositoryService repoService = (DvcsRepositoryService)this.repositoryService.getService();
        List<Changeset> changesets = service.getChangesets(issueKeys, dvcsApplicationTypeInfo.getType().getType());
        try {
            changesets = this.changesetDetailsFetcher.getChangesetsWithFileDetails(changesets, executorService);
        }
        catch (TimeoutException e) {
            logger.info(String.format("Timeout fetching file details for %s from %s", issueKeys, dvcsApplicationTypeInfo));
        }
        LinkedHashMultimap changesetsByRepoId = LinkedHashMultimap.create();
        for (Changeset changeset : changesets) {
            for (Integer repoId : changeset.getRepositoryIds()) {
                changesetsByRepoId.put((Object)repoId, (Object)changeset);
            }
        }
        Repositories.Builder reposBuilder = new Repositories.Builder();
        for (Map.Entry entry : changesetsByRepoId.asMap().entrySet()) {
            Integer repositoryId = (Integer)entry.getKey();
            Repository repository = repoService.getRepository(repositoryId.intValue());
            if (!dvcsApplicationTypeInfo.getType().matches(repository.getDvcsType())) continue;
            Repository.Builder repoBuilder = new Repository.Builder(repository.getName());
            repoBuilder.url(repository.getRepositoryUrl());
            repoBuilder.avatar(repository.getLogo());
            repoBuilder.parent(this.baseRepoForDvcsRepo(repository.getForkOf()));
            for (Changeset changeset : (Collection)entry.getValue()) {
                final Map fileChangesetsUrls = service.getFileChangesets(repository, changeset);
                DvcsUser dvcsUser = repoService.getDvcsUser(repository, changeset.getAuthor(), changeset.getRawAuthor());
                repoBuilder.addCommit(((Commit.Builder)((Commit.Builder)((Commit.Builder)new Commit.Builder(changeset.getNode()).displayId(changeset.getNode().substring(0, 7))).authorTimestamp(changeset.getDate())).fileCount(changeset.getAllFileCount()).addFiles(Iterables.transform((Iterable)Iterables.limit((Iterable)changeset.getFiles(), (int)5), (Function)new Function<ChangesetFile, File>(){

                    public File apply(ChangesetFile file) {
                        File.Builder builder = new File.Builder(file.getFile(), (String)fileChangesetsUrls.get(file), DvcsCommitDetailHelper.getFileAction(file.getFileAction()));
                        if (file instanceof ChangesetFileDetail) {
                            ChangesetFileDetail fileDetail = (ChangesetFileDetail)file;
                            builder.linesAdded(fileDetail.getAdditions()).linesRemoved(fileDetail.getDeletions());
                        }
                        return builder.build();
                    }
                })).merge(changeset.getParents().size() > 1).message(changeset.getMessage()).author(((Committer.Builder)new Committer.Builder((String)StringUtils.defaultIfBlank((CharSequence)dvcsUser.getFullName(), (CharSequence)dvcsUser.getUsername())).avatar(dvcsUser.getAvatar())).build()).url(new UrlBuilder(repository.getRepositoryUrl()).addPath(dvcsApplicationTypeInfo.getCommitPath()).addPath(changeset.getNode()).asUrlString())).build());
            }
            reposBuilder.add(repoBuilder.build());
        }
        return reposBuilder.build();
    }

    private BaseRepository baseRepoForDvcsRepo(Repository parent) {
        if (parent == null) {
            return null;
        }
        return ((BaseRepository.Builder)new BaseRepository.Builder(parent.getName()).url(parent.getRepositoryUrl())).build();
    }

    private static File.ChangeType getFileAction(ChangesetFileAction fileAction) {
        if (fileAction == ChangesetFileAction.ADDED) {
            return File.ChangeType.ADDED;
        }
        if (fileAction == ChangesetFileAction.REMOVED) {
            return File.ChangeType.DELETED;
        }
        return File.ChangeType.MODIFIED;
    }
}

