/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.guava.base.Stopwatch;
import com.atlassian.guava.collect.ImmutableList;
import com.atlassian.guava.collect.Lists;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsChangesetServiceAccessor;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsChangesetService;
import com.atlassian.util.concurrent.TimedOutException;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class ChangesetDetailsFetcher {
    @VisibleForTesting
    static final int MAX_FAN_OUT = 10;
    @VisibleForTesting
    static final int DEFAULT_TIMEOUT_SECS = 5;
    private static final Logger logger = LoggerFactory.getLogger(ChangesetDetailsFetcher.class);
    private final DvcsChangesetServiceAccessor changesetServiceAccessor;
    private final int timeout;

    @Inject
    ChangesetDetailsFetcher(DvcsChangesetServiceAccessor changesetServiceAccessor) {
        this(changesetServiceAccessor, Integer.getInteger("jira.devstatus.dvcs.details.timeout", 5));
    }

    @VisibleForTesting
    ChangesetDetailsFetcher(DvcsChangesetServiceAccessor changesetServiceAccessor, int timeout) {
        this.changesetServiceAccessor = changesetServiceAccessor;
        this.timeout = timeout;
    }

    public List<Changeset> getChangesetsWithFileDetails(List<Changeset> changesets, ExecutorService executorService) throws TimeoutException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ConcurrentLinkedQueue<Changeset> workQueue = new ConcurrentLinkedQueue<Changeset>(changesets);
        List<Callable<List<Changeset>>> fetchers = this.createDetailsFetchers(workQueue);
        try {
            List<Future<List<Changeset>>> futureChangesets = executorService.invokeAll(fetchers, this.timeout, TimeUnit.SECONDS);
            ImmutableList.Builder detailChangesets = ImmutableList.builder();
            for (Future<List<Changeset>> future : futureChangesets) {
                try {
                    detailChangesets.addAll(future.get());
                }
                catch (CancellationException e) {
                    logger.debug("Got {} changesets in {}ms before timing out", (Object)(changesets.size() - workQueue.size()), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                    throw new TimedOutException((long)this.timeout, TimeUnit.SECONDS);
                }
            }
            logger.debug("Got {} changesets in {}ms", (Object)changesets.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return detailChangesets.build();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Callable<List<Changeset>>> createDetailsFetchers(final Queue<Changeset> changesets) {
        final DvcsChangesetService service = (DvcsChangesetService)this.changesetServiceAccessor.getService();
        if (service == null) {
            throw new IllegalStateException("DvcsChangesetService is not available");
        }
        int fetcherCount = Math.min(10, changesets.size());
        ArrayList<Callable<List<Changeset>>> fetchers = Lists.newArrayListWithCapacity(fetcherCount);
        for (int i = 0; i < fetcherCount; ++i) {
            fetchers.add(new Callable<List<Changeset>>(){

                @Override
                public List<Changeset> call() throws Exception {
                    Changeset changeset;
                    Thread thread = Thread.currentThread();
                    ImmutableList.Builder results = ImmutableList.builder();
                    while (!thread.isInterrupted() && (changeset = (Changeset)changesets.poll()) != null) {
                        results.addAll((Iterable)service.getChangesetsWithFileDetails(ImmutableList.of(changeset)));
                    }
                    return results.build();
                }
            });
        }
        return fetchers;
    }
}

