/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.BitbucketSource;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsApplicationTypeInfo;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsFacade;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.util.UrlBuilder;

public class BitbucketInfo
implements DvcsApplicationTypeInfo {
    @Override
    public DvcsFacade.DvcsApplicationType getType() {
        return DvcsFacade.DvcsApplicationType.BITBUCKET;
    }

    @Override
    public Source getSource() {
        return BitbucketSource.INSTANCE;
    }

    @Override
    public String getCreatePullRequestUrl(Repository repository, String sourceBranch) {
        if (repository != null && sourceBranch != null) {
            return new UrlBuilder(repository.getOrgHostUrl()).addPath(repository.getOrgName()).addPath(repository.getSlug()).addPaths("pull-request/new").addParameter("source", repository.getOrgName() + '/' + repository.getSlug() + "::" + sourceBranch).asUrlString();
        }
        return null;
    }

    @Override
    public String getBranchPath() {
        return "branch";
    }

    @Override
    public String getCommitPath() {
        return "changeset";
    }
}

