/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.cache;

import com.atlassian.jira.plugin.devstatus.cache.JsonStore;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.JsonStoreFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DevSummaryStore {
    private static final Logger logger = LoggerFactory.getLogger(DevSummaryStore.class);
    @VisibleForTesting
    static final String FUSION_CACHE_PREFIX = "fusion.caches.issue";
    private final JsonStore<DataProviderResponse> jsonStore;

    @Inject
    public DevSummaryStore(JsonStoreFactory jsonStoreFactory) {
        this.jsonStore = jsonStoreFactory.create(DataProviderResponse.class, FUSION_CACHE_PREFIX);
    }

    @Nonnull
    public Map<String, DataProviderResponse> getAll(long issueId) {
        Map<String, DataProviderResponse> responses = this.jsonStore.getAll(issueId);
        logger.debug("Getting all responses for issueId={}: {}", (Object)issueId, responses);
        return responses;
    }

    @Nullable
    public DataProviderResponse get(long issueId, String sourceId) {
        DataProviderResponse response = this.jsonStore.get(issueId, sourceId);
        logger.debug("Getting response for issueId={} and source={}: {}", new Object[]{issueId, sourceId, response});
        return response;
    }

    public void put(long issueId, String sourceId, DataProviderResponse response) {
        logger.debug("Putting response for issueId={} and source={}: {}", new Object[]{issueId, sourceId, response});
        this.jsonStore.put(issueId, sourceId, response);
    }
}

