/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.cache;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.DevSummaryStore;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingProviderDecorator
implements DataProvider {
    @VisibleForTesting
    static final Duration DEFAULT_TTL = Duration.standardSeconds((long)30L);
    private static final Logger logger = LoggerFactory.getLogger(CachingProviderDecorator.class);
    private final DataProvider dataProvider;
    private final DevSummaryStore devSummaryStore;
    private final Clock clock;

    @VisibleForTesting
    public CachingProviderDecorator(@Nonnull DataProvider dataProvider, @Nonnull DevSummaryStore devSummaryStore, Clock clock) {
        this.dataProvider = (DataProvider)Preconditions.checkNotNull((Object)dataProvider, (Object)"dataProvider");
        this.devSummaryStore = (DevSummaryStore)Preconditions.checkNotNull((Object)devSummaryStore, (Object)"devSummaryCaches");
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
    }

    @Override
    public Source getSource() {
        return this.dataProvider.getSource();
    }

    @Override
    @Nonnull
    public Promise<DataProviderResponse> getSummaryDataFutureFor(@Nonnull IssueDataRequest summaryRequest) {
        DataProviderResponse cachedResponse;
        if (!summaryRequest.isBypassCache() && (cachedResponse = this.devSummaryStore.get(summaryRequest.issueId(), this.getSource().getId())) != null && !new DateTime((Object)cachedResponse.staleAfter()).isBeforeNow()) {
            logger.trace("Returning from cache for {}: {}", (Object)summaryRequest, (Object)cachedResponse);
            return Promises.promise((Object)DataProviderResponse.success(cachedResponse.jsonBytes()));
        }
        return this.fetchSummaryData(summaryRequest);
    }

    @Override
    @Nonnull
    public Promise<DataProviderResponse> getDetailDataFutureFor(@Nonnull IssueDataRequest detailDataRequest, @Nonnull String type) {
        return this.dataProvider.getDetailDataFutureFor(detailDataRequest, type);
    }

    @Override
    public boolean isAuthenticated() {
        return this.dataProvider.isAuthenticated();
    }

    @Override
    public boolean isConfigured() {
        return this.dataProvider.isConfigured();
    }

    public void refresh(Set<IssueDataRequest> issuesToRefresh) {
        for (IssueDataRequest issueToRefresh : issuesToRefresh) {
            this.fetchSummaryData(issueToRefresh);
        }
    }

    @Override
    public void destroy() {
        this.dataProvider.destroy();
    }

    private static String toString(Source source) {
        return "Source[" + source.getBaseUrl() + "]";
    }

    private Promise<DataProviderResponse> fetchSummaryData(IssueDataRequest summaryRequest) {
        logger.trace("Fetching data from underlying provider: {}", (Object)summaryRequest);
        return this.dataProvider.getSummaryDataFutureFor(summaryRequest).done((Effect)new StoreValueInCache(summaryRequest));
    }

    private DateTime getStaleAfter(DataProviderResponse response) {
        DateTime staleAfter;
        Date now = this.clock.getCurrentDate();
        DateTime defaultStaleAfter = new DateTime(now.getTime()).plus((ReadableDuration)DEFAULT_TTL);
        return defaultStaleAfter.isAfter((ReadableInstant)(staleAfter = new DateTime(Objects.firstNonNull((Object)response.staleAfter(), (Object)now)))) ? defaultStaleAfter : staleAfter;
    }

    private class StoreValueInCache
    implements Effect<DataProviderResponse> {
        private final IssueDataRequest summaryRequest;

        public StoreValueInCache(IssueDataRequest summaryRequest) {
            this.summaryRequest = summaryRequest;
        }

        public void apply(DataProviderResponse summaryDataResponse) {
            if (logger.isTraceEnabled()) {
                logger.trace("{} > DataProviderResponse is: {}", (Object)CachingProviderDecorator.toString(CachingProviderDecorator.this.dataProvider.getSource()), (Object)summaryDataResponse);
            }
            if (!summaryDataResponse.isSuccessful()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} > Received error response for {}, NOT storing in cache.", (Object)CachingProviderDecorator.toString(CachingProviderDecorator.this.dataProvider.getSource()));
                }
                return;
            }
            DateTime staleAfter = CachingProviderDecorator.this.getStaleAfter(summaryDataResponse);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("%s > Received response for %s, storing in cache with expiry = %s.", CachingProviderDecorator.toString(CachingProviderDecorator.this.dataProvider.getSource()), this.summaryRequest, staleAfter));
            }
            CachingProviderDecorator.this.devSummaryStore.put(this.summaryRequest.issueId(), CachingProviderDecorator.this.getSource().getId(), DataProviderResponse.success(summaryDataResponse.jsonBytes(), staleAfter.toDate()));
        }
    }
}

