/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.core.util.Clock;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.source.ThreadPool;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkDataProvider;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkDataProviderFactory;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkRateLimiter;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkSecurityHelper;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.TrustedAppsHelper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class CapabilityDataProviderFactory
implements ApplicationLinkDataProviderFactory {
    private final ExecutorService executorService;
    private final I18nHelper i18nHelper;
    private final TrustedAppsHelper trustedAppsHelper;
    private final ApplicationLinkRateLimiter rateLimiter;
    private final Clock clock;

    @Inject
    public CapabilityDataProviderFactory(@ComponentImport I18nHelper i18nHelper, TrustedAppsHelper trustedAppsHelper, ApplicationLinkRateLimiter rateLimiter, Clock clock) {
        this(CapabilityDataProviderFactory.createExecutorService(), i18nHelper, trustedAppsHelper, rateLimiter, clock);
    }

    @VisibleForTesting
    CapabilityDataProviderFactory(ExecutorService executorService, @ComponentImport I18nHelper i18nHelper, TrustedAppsHelper trustedAppsHelper, ApplicationLinkRateLimiter rateLimiter, Clock clock) {
        this.executorService = executorService;
        this.i18nHelper = i18nHelper;
        this.trustedAppsHelper = trustedAppsHelper;
        this.rateLimiter = rateLimiter;
        this.clock = clock;
    }

    @PreDestroy
    public void shutdownThreadPool() {
        this.executorService.shutdown();
    }

    @Override
    @Nonnull
    public DataProvider create(@Nonnull ApplicationLink applicationLink, @Nonnull String summaryUrl, @Nonnull Function<String, String> detailUrlLookup) {
        ApplicationLinkSecurityHelper securityHelper = new ApplicationLinkSecurityHelper(applicationLink, this.trustedAppsHelper);
        return new ApplicationLinkDataProvider(applicationLink, detailUrlLookup, this.executorService, this.i18nHelper, summaryUrl, this.rateLimiter, this.clock, securityHelper);
    }

    private static ExecutorService createExecutorService() {
        return ThreadPool.builder().name("applink").coreThreads(4).maxThreads(20).boundedQueue(4096).build();
    }
}

