/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.data;

import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.data.FetchError;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryData;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryDataItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SummaryDataBuilder {
    private final List<SummaryDataItem> items = Lists.newArrayList();

    public SummaryDataBuilder addResponse(Source source, DataProviderResponse response) {
        this.items.add(new SummaryDataItem(source, response));
        return this;
    }

    public SummaryDataBuilder addSuccess(Source source, byte[] right) {
        return this.addResponse(source, DataProviderResponse.success(right));
    }

    public SummaryDataBuilder addFailure(Source source, FetchError error) {
        return this.addResponse(source, DataProviderResponse.failure(error));
    }

    public SummaryData build() {
        return new SummaryData((ImmutableList<SummaryDataItem>)ImmutableList.copyOf(this.items));
    }
}

