/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingDecorator<T>
implements Callable<T> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingDecorator.class);
    @Nonnull
    private final String description;
    @Nonnull
    private final Callable<T> callable;

    public static <T> LoggingDecorator<T> decorate(@Nonnull String name, @Nonnull Callable<T> callable) {
        return new LoggingDecorator<T>(name, callable);
    }

    public LoggingDecorator(@Nonnull String description, @Nonnull Callable<T> callable) {
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.callable = (Callable)Preconditions.checkNotNull(callable, (Object)"callable");
    }

    @Override
    public T call() throws Exception {
        Stopwatch stopwatch = new Stopwatch();
        try {
            T result = this.callable.call();
            logger.debug("Call '{}' completed in {}ms", (Object)this.description, (Object)stopwatch.elapsedMillis());
            return result;
        }
        catch (Exception e) {
            logger.error(String.format("Call '%s' has thrown an exception", this.description), (Throwable)e);
            throw e;
        }
    }
}

