/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IssueDataRequest {
    private final long issueId;
    private final ImmutableSet<String> issueKeys;
    private final boolean bypassCache;

    public IssueDataRequest(long issueId, @Nonnull Iterable<String> issueKeys) {
        this.issueId = issueId;
        this.issueKeys = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(issueKeys, (Object)"issueKeys")));
        this.bypassCache = false;
    }

    public IssueDataRequest(long issueId, @Nonnull Iterable<String> issueKeys, boolean bypassCache) {
        this.issueId = issueId;
        this.issueKeys = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(issueKeys, (Object)"issueKeys")));
        this.bypassCache = bypassCache;
    }

    public long issueId() {
        return this.issueId;
    }

    public ImmutableSet<String> issueKeys() {
        return this.issueKeys;
    }

    public boolean isBypassCache() {
        return this.bypassCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueDataRequest that = (IssueDataRequest)o;
        if (this.bypassCache != that.bypassCache) {
            return false;
        }
        if (this.issueId != that.issueId) {
            return false;
        }
        return this.issueKeys.equals(that.issueKeys);
    }

    public int hashCode() {
        int result = (int)(this.issueId ^ this.issueId >>> 32);
        result = 31 * result + this.issueKeys.hashCode();
        result = 31 * result + (this.bypassCache ? 1 : 0);
        return result;
    }

    public String toString() {
        return "IssueDataRequest{issueId=" + this.issueId + ", issueKeys=" + this.issueKeys + ", bypassCache=" + this.bypassCache + '}';
    }
}

