/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider;

import com.atlassian.core.util.Clock;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderHelper;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderSource;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.CachingProviderDecorator;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.DevSummaryStore;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultDataProviderHelper
implements DataProviderHelper {
    Logger log = LoggerFactory.getLogger(DefaultDataProviderHelper.class);
    private final List<DataProviderSource> dataProviderSources;
    private final DevSummaryStore devSummaryStore;
    private final Clock clock;

    @Inject
    public DefaultDataProviderHelper(List<DataProviderSource> dataProviderSources, DevSummaryStore devSummaryStore, Clock clock) {
        this.dataProviderSources = dataProviderSources;
        this.devSummaryStore = devSummaryStore;
        this.clock = clock;
    }

    @Override
    public Collection<DataProvider> getDataProviders() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataProviderSource dataProviderSource : this.dataProviderSources) {
            builder.addAll(this.wrapInCachedProvider(dataProviderSource));
        }
        return builder.build();
    }

    @Override
    public Option<DataProvider> getFromId(final String id) {
        if (id == null) {
            return Option.none();
        }
        Collection filtered = Collections2.filter(this.getDataProviders(), (Predicate)new Predicate<DataProvider>(){

            public boolean apply(DataProvider input) {
                return id.equals(input.getSource().getId());
            }
        });
        if (filtered.size() > 1) {
            this.log.debug("Non-unique data provider for ID: {}", (Object)id);
        }
        return Iterables.first((Iterable)filtered);
    }

    @Override
    public Option<DataProvider> getFromBaseUrl(final String baseUrl) {
        if (baseUrl == null) {
            return Option.none();
        }
        Collection filtered = Collections2.filter(this.getDataProviders(), (Predicate)new Predicate<DataProvider>(){

            public boolean apply(DataProvider input) {
                URI sourceUrl;
                URI baseUri;
                try {
                    baseUri = URI.create(baseUrl);
                    sourceUrl = URI.create(input.getSource().getBaseUrl());
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                return baseUri.equals(sourceUrl);
            }
        });
        if (filtered.size() > 1) {
            this.log.debug("Non-unique data provider for Base URL: {}", (Object)baseUrl);
        }
        return Iterables.first((Iterable)filtered);
    }

    private ImmutableList<DataProvider> wrapInCachedProvider(DataProviderSource dataProviderSource) {
        ImmutableList.Builder cachedProviders = ImmutableList.builder();
        for (DataProvider dataProvider : dataProviderSource.availableProviders()) {
            cachedProviders.add((Object)new CachingProviderDecorator(dataProvider, this.devSummaryStore, this.clock));
        }
        return cachedProviders.build();
    }
}

