/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.labs;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.devstatus.api.DevStatusDismissableService;
import com.atlassian.jira.plugin.devstatus.labs.LabsJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class LabsOptIn {
    @VisibleForTesting
    static final String LABS_ALLOWED = "jira.plugin.devstatus.labs.phase3";
    @VisibleForTesting
    static final String LABS_PHASE_TWO = "jira.plugin.devstatus.phasetwo";
    private final JiraAuthenticationContext authContext;
    private final DevStatusDismissableService devStatusDismissableService;
    private final FeatureManager featureManager;

    @Inject
    public LabsOptIn(@ComponentImport JiraAuthenticationContext authContext, DevStatusDismissableService devStatusDismissableService, @ComponentImport FeatureManager featureManager) {
        this.authContext = authContext;
        this.featureManager = featureManager;
        this.devStatusDismissableService = devStatusDismissableService;
    }

    public boolean isAllowed() {
        ApplicationUser user = this.authContext.getUser();
        return this.featureManager.isEnabled(LABS_ALLOWED) && (user != null || this.isOptedInByAdmin());
    }

    public boolean isOptedIn() {
        ApplicationUser user = this.authContext.getUser();
        return this.featureManager.isEnabledForUser(user, LABS_PHASE_TWO);
    }

    public boolean isOptedInByAdmin() {
        return this.featureManager.getDarkFeatures().getGlobalEnabledFeatureKeys().contains(LABS_PHASE_TWO);
    }

    public boolean isDismissed() {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return false;
        }
        ServiceOutcome<Boolean> outcome = this.devStatusDismissableService.isDismissed(user, "jira.plugin.devstatus.labs.dismissed");
        return !outcome.isValid() || (Boolean)outcome.getReturnedValue() != false;
    }

    public void setDismissed(boolean dismissed) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            throw new IllegalStateException("Can't dismiss Labs info for anonymous users");
        }
        ServiceOutcome<Void> outcome = this.devStatusDismissableService.setDismissed(user, "jira.plugin.devstatus.labs.dismissed", dismissed);
        if (!outcome.isValid()) {
            throw new RuntimeException(StringUtils.join((Iterable)outcome.getErrorCollection().getErrorMessages(), (String)" "));
        }
    }

    public void setOptedIn(Boolean optedIn) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            throw new IllegalStateException("Can't enable FusionLabs for anonymous users");
        }
        if (optedIn.booleanValue()) {
            this.featureManager.enableUserDarkFeature(user, LABS_PHASE_TWO);
        } else {
            this.featureManager.disableUserDarkFeature(user, LABS_PHASE_TWO);
        }
    }

    public LabsJsonBean asJsonBean() {
        return new LabsJsonBean(this.isAllowed(), this.isOptedIn(), this.isOptedInByAdmin(), this.isDismissed());
    }
}

