/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.devstatus.api.DevStatusPermissionService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusValidationService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@ExportAsService
@Named
public class DefaultDevStatusValidationService
implements DevStatusValidationService {
    private final DevStatusPermissionService devStatusPermissionService;
    private final IssueService issueService;
    private final I18nHelper i18nHelper;

    @Inject
    public DefaultDevStatusValidationService(DevStatusPermissionService devStatusPermissionService, @ComponentImport I18nHelper i18nHelper, @ComponentImport IssueService issueService) {
        this.devStatusPermissionService = devStatusPermissionService;
        this.issueService = issueService;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public ServiceOutcome<Boolean> checkPermission(Issue issue, ApplicationUser user) {
        ServiceOutcome<Boolean> permissionCheckOutcome = this.devStatusPermissionService.hasPermission(issue, user);
        if (!permissionCheckOutcome.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheckOutcome);
        }
        if (!((Boolean)permissionCheckOutcome.getReturnedValue()).booleanValue()) {
            return ServiceOutcomeImpl.error((String)this.i18nHelper.getText("devstatus.cta.error.no.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN);
        }
        return permissionCheckOutcome;
    }

    @Override
    public Either<String, String> validateCta(String callToAction, ApplicationUser user) {
        if (StringUtils.isEmpty((CharSequence)callToAction)) {
            return Either.left((Object)this.i18nHelper.getText("devstatus.cta.error.empty.cta"));
        }
        return Either.right((Object)callToAction);
    }

    @Override
    public Either<String, Issue> validateIssueId(long issueId, ApplicationUser user) {
        if (issueId < 0L) {
            return Either.left((Object)this.i18nHelper.getText("devstatus.cta.error.invalid.issueId", String.valueOf(issueId)));
        }
        IssueService.IssueResult issueResult = this.issueService.getIssue(ApplicationUsers.toDirectoryUser((ApplicationUser)user), Long.valueOf(issueId));
        if (!issueResult.isValid()) {
            return Either.left((Object)this.i18nHelper.getText("devstatus.cta.error.unknown.issue", String.valueOf(issueId)));
        }
        return Either.right((Object)issueResult.getIssue());
    }

    @Override
    public Either<String, Issue> validateIssue(Issue issue, ApplicationUser user) {
        if (issue == null) {
            return Either.left((Object)this.i18nHelper.getText("devstatus.cta.error.null.issue"));
        }
        return Either.right((Object)issue);
    }
}

