/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationLinkService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationService;
import com.atlassian.jira.plugin.devstatus.api.SupportedApplication;
import com.atlassian.jira.plugin.devstatus.impl.ApplicationCapabilities;
import com.atlassian.jira.plugin.devstatus.impl.Capability;
import com.atlassian.jira.plugin.devstatus.impl.DvcsType;
import com.atlassian.jira.plugin.devstatus.impl.NavigationKeys;
import com.atlassian.jira.plugin.devstatus.labs.PhaseTwoFeatureFlag;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsLinkServiceAccessor;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsLinkService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.plugins.navlink.consumer.menu.services.RemoteNavigationLinkService;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultDevStatusSupportedApplicationService
implements DevStatusSupportedApplicationService {
    private final ApplicationLinkService applicationLinkService;
    private final DvcsLinkServiceAccessor dvcsLinkServiceAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final RemoteNavigationLinkService remoteNavigationLinkService;
    private final LinkedApplicationCapabilities capabilityService;
    private final PhaseTwoFeatureFlag phaseTwoFeatureFlag;
    private final DevStatusSupportedApplicationLinkService devStatusSupportedApplicationLinkService;

    @Inject
    public DefaultDevStatusSupportedApplicationService(@ComponentImport ApplicationLinkService applicationLinkService, DvcsLinkServiceAccessor dvcsLinkServiceAccessor, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport RemoteNavigationLinkService remoteNavigationLinkService, @ComponentImport LinkedApplicationCapabilities capabilityService, PhaseTwoFeatureFlag phaseTwoFeatureFlag, DevStatusSupportedApplicationLinkService devStatusSupportedApplicationLinkService) {
        this.applicationLinkService = applicationLinkService;
        this.dvcsLinkServiceAccessor = dvcsLinkServiceAccessor;
        this.authenticationContext = authenticationContext;
        this.remoteNavigationLinkService = remoteNavigationLinkService;
        this.capabilityService = capabilityService;
        this.phaseTwoFeatureFlag = phaseTwoFeatureFlag;
        this.devStatusSupportedApplicationLinkService = devStatusSupportedApplicationLinkService;
    }

    @Override
    public ServiceOutcome<List<SupportedApplication>> getSupportedApplications() {
        Map<String, Set<Capability>> actionsPerApplinkLink = this.getCapabilitiesPerApplink();
        LinkedList supportedApplications = Lists.newLinkedList();
        supportedApplications.addAll(this.getSupportedApplications(BambooApplicationType.class, actionsPerApplinkLink));
        supportedApplications.addAll(this.getBitbucketSupportedApplication());
        supportedApplications.addAll(this.getSupportedApplications(FishEyeCrucibleApplicationType.class, actionsPerApplinkLink));
        supportedApplications.addAll(this.getGitHubSupportedApplication());
        supportedApplications.addAll(this.getGitHubEnterpriseSupportedApplication());
        supportedApplications.addAll(this.getSupportedApplications(StashApplicationType.class, actionsPerApplinkLink));
        Collections.sort(supportedApplications, new Comparator<SupportedApplication>(){

            @Override
            public int compare(SupportedApplication o1, SupportedApplication o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        return ServiceOutcomeImpl.ok((Object)supportedApplications);
    }

    private List<SupportedApplication> getGitHubEnterpriseSupportedApplication() {
        String githubE = DvcsType.GITHUB_ENTERPRISE.type();
        String applicationType = "GitHub Enterprise";
        return this.getSupportedApplication(githubE, (Option<String>)Option.none(), applicationType);
    }

    private List<SupportedApplication> getGitHubSupportedApplication() {
        String github = DvcsType.GITHUB.type();
        String applicationDisplayName = "GitHub";
        String applicationType = "GitHub";
        return this.getSupportedApplication(github, (Option<String>)Option.some((Object)applicationDisplayName), applicationType);
    }

    private List<SupportedApplication> getBitbucketSupportedApplication() {
        String bitbucket = DvcsType.BITBUCKET.type();
        String applicationDisplayName = "Bitbucket";
        String applicationType = "Bitbucket";
        return this.getSupportedApplication(bitbucket, (Option<String>)Option.some((Object)applicationDisplayName), applicationType);
    }

    private List<SupportedApplication> getSupportedApplication(String application, Option<String> applicationDisplayName, String applicationType) {
        DvcsLinkService dvcsLinkService = this.dvcsLinkServiceAccessor.getService();
        if (dvcsLinkService == null) {
            return ImmutableList.of();
        }
        Iterable<Organization> organizations = DefaultDevStatusSupportedApplicationService.excludeNulls(dvcsLinkService.getDvcsLinks(false, application));
        if (Iterables.isEmpty(organizations)) {
            return ImmutableList.of();
        }
        if (DvcsType.GITHUB_ENTERPRISE.type().equals(application)) {
            return this.getSupportedApplications(applicationDisplayName, applicationType, organizations);
        }
        Organization organization = (Organization)organizations.iterator().next();
        Org2SupportedAppConverter converter = new Org2SupportedAppConverter(applicationType, applicationDisplayName);
        return ImmutableList.of((Object)converter.apply(organization));
    }

    private List<SupportedApplication> getSupportedApplications(Option<String> applicationDisplayName, String applicationType, Iterable<Organization> organisations) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(organisations, (Function)new Org2SupportedAppConverter(applicationType, applicationDisplayName)));
    }

    @VisibleForTesting
    List<SupportedApplication> getSupportedApplications(Class<? extends ApplicationType> type, final @Nonnull Map<String, Set<Capability>> capabilitiesPerLink) {
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks(type);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)applicationLinks, (Function)new ApplicationConverter(){

            @Override
            protected Set<Capability> getCapabilities(ApplicationLink appLink) {
                String id = appLink.getId().get();
                return capabilitiesPerLink.containsKey(id) ? (Set)capabilitiesPerLink.get(id) : ImmutableSet.of();
            }
        }));
    }

    @VisibleForTesting
    static <T> Iterable<T> excludeNulls(List<T> dvcsLinks) {
        return Iterables.filter(dvcsLinks, (Predicate)Predicates.notNull());
    }

    @VisibleForTesting
    Map<String, Set<Capability>> getCapabilitiesPerApplink() {
        HashMap appLinksToCapabilities = Maps.newHashMap();
        Set navLinks = this.remoteNavigationLinkService.all(this.getI18nHelper().getLocale());
        for (NavigationLink navLink : navLinks) {
            String navLinkKey = navLink.getKey();
            Option<Capability> capability = Capability.fromString(navLinkKey);
            if (!capability.isDefined() || !NavigationKeys.CALL_TO_ACTIONS.contains(navLinkKey) || !this.phaseTwoFeatureFlag.isPhaseTwoEnabled() && this.phaseTwoFeatureFlag.isPhaseTwoCallToAction(navLinkKey)) continue;
            String id = navLink.getSource().id();
            this.addCapabilityToApp(appLinksToCapabilities, (Capability)capability.get(), id);
        }
        if (this.phaseTwoFeatureFlag.isPhaseTwoEnabled()) {
            HashMap idToIsFisheye = Maps.newHashMap();
            for (ApplicationLink i : this.applicationLinkService.getApplicationLinks()) {
                idToIsFisheye.put(i.getId().get(), i.getType() instanceof FishEyeCrucibleApplicationType);
            }
            for (Capability capability : ApplicationCapabilities.allCapabilities()) {
                String name = capability.getName();
                Set linkedAppsWithCapabilities = this.capabilityService.capableOf(name);
                for (LinkedAppWithCapabilities app : linkedAppsWithCapabilities) {
                    String id = app.getApplicationLinkId();
                    Boolean isFisheye = (Boolean)idToIsFisheye.get(id);
                    if (isFisheye == null) {
                        isFisheye = false;
                    }
                    DefaultDevStatusSupportedApplicationService.addCapabilityToApp(appLinksToCapabilities, capability, id, isFisheye);
                }
            }
        }
        return appLinksToCapabilities;
    }

    private void addCapabilityToApp(Map<String, Set<Capability>> appLinksToCapabilities, Capability capability, String id) {
        DefaultDevStatusSupportedApplicationService.addCapabilityToApp(appLinksToCapabilities, capability, id, false);
    }

    @VisibleForTesting
    static void addCapabilityToApp(Map<String, Set<Capability>> appLinksToCapabilities, Capability capability, String id, boolean isFisheye) {
        if (!appLinksToCapabilities.containsKey(id)) {
            appLinksToCapabilities.put(id, Sets.newHashSet());
        }
        if (isFisheye && capability.equals(ApplicationCapabilities.STATUS_PULLREQUEST)) {
            appLinksToCapabilities.get(id).add(ApplicationCapabilities.STATUS_BRANCH);
        } else if (!isFisheye && (capability.equals(ApplicationCapabilities.STATUS_BRANCH) || capability.equals(ApplicationCapabilities.STATUS_PULLREQUEST))) {
            appLinksToCapabilities.get(id).add(ApplicationCapabilities.STATUS_BRANCH);
            appLinksToCapabilities.get(id).add(ApplicationCapabilities.STATUS_PULLREQUEST);
        } else {
            appLinksToCapabilities.get(id).add(capability);
        }
    }

    private I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }

    private boolean isAppLinkConfiguredForSummaryData(ApplicationLink appLink) {
        return this.devStatusSupportedApplicationLinkService.recheckAppLink2LOSupport(appLink);
    }

    private static class Org2SupportedAppConverter
    implements Function<Organization, SupportedApplication> {
        private final String applicationType;
        private final Option<String> applicationDisplayName;

        public Org2SupportedAppConverter(String applicationType, Option<String> applicationDisplayName) {
            this.applicationType = applicationType;
            this.applicationDisplayName = applicationDisplayName;
        }

        public SupportedApplication apply(Organization organization) {
            ApplicationCapabilities expectedApplicationCapabilities = ApplicationCapabilities.UNKNOWN;
            String name = "unknown";
            String hostUrl = "";
            if (organization != null) {
                expectedApplicationCapabilities = DvcsType.fromString(organization.getDvcsType()).capabilities();
                name = organization.getName();
                hostUrl = organization.getHostUrl();
            }
            return new SupportedApplication(null, (String)this.applicationDisplayName.getOrElse((Object)name), this.applicationType, hostUrl, expectedApplicationCapabilities.expected(), expectedApplicationCapabilities.expected(), true);
        }
    }

    private abstract class ApplicationConverter
    implements Function<ApplicationLink, SupportedApplication> {
        private ApplicationConverter() {
        }

        public SupportedApplication apply(ApplicationLink appLink) {
            Set<Capability> capabilities = this.getCapabilities(appLink);
            Set<Capability> expectedCapabilities = DefaultDevStatusSupportedApplicationService.this.phaseTwoFeatureFlag.isPhaseTwoEnabled() ? ApplicationCapabilities.fromApplink(appLink).expected() : ApplicationCapabilities.NO_CAPABILITIES.expected();
            boolean isConfiguredForSummaryData = !DefaultDevStatusSupportedApplicationService.this.phaseTwoFeatureFlag.isPhaseTwoEnabled() || DefaultDevStatusSupportedApplicationService.this.isAppLinkConfiguredForSummaryData(appLink);
            return new SupportedApplication(appLink.getType().getIconUrl().toString(), appLink.getName(), DefaultDevStatusSupportedApplicationService.this.getI18nHelper().getText(appLink.getType().getI18nKey()), appLink.getDisplayUrl().toString(), capabilities, expectedCapabilities, isConfiguredForSummaryData);
        }

        protected abstract Set<Capability> getCapabilities(ApplicationLink var1);
    }
}

