/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.devstatus.api.DevStatusPermissionService;
import com.atlassian.jira.plugin.devstatus.api.PermissionHolder;
import com.atlassian.jira.plugin.devstatus.api.PermissionHolders;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@ExportAsService
@Named
public class DefaultDevStatusPermissionService
implements DevStatusPermissionService {
    static final Permissions.Permission VIEW_DEV_TOOLS_PERMISSION = Permissions.Permission.VIEW_VERSION_CONTROL;
    static final Permissions.Permission BROWSE_PERMISSION = Permissions.Permission.BROWSE;
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_PARAMETER = "parameter";
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper i18nHelper;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final SecurityTypeManager securityTypeManager;

    @Inject
    public DefaultDevStatusPermissionService(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport I18nHelper i18nHelper, @ComponentImport PermissionManager permissionManager, @ComponentImport PermissionSchemeManager permissionSchemeManager, @ComponentImport SecurityTypeManager securityTypeManager) {
        this.authenticationContext = authenticationContext;
        this.i18nHelper = i18nHelper;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.securityTypeManager = securityTypeManager;
    }

    @Override
    public ServiceOutcome<Boolean> hasPermission(@Nonnull Issue issue, @Nonnull ApplicationUser user) {
        Option<String> validationError = this.validate(issue, user);
        if (validationError.isDefined()) {
            return ServiceOutcomeImpl.error((String)((String)validationError.get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        boolean hasPermission = this.permissionManager.hasPermission(BROWSE_PERMISSION.getId(), issue, user);
        if (hasPermission) {
            Project project = issue.getProjectObject();
            Option<String> projectValidationError = this.validate(project, user);
            if (projectValidationError.isDefined()) {
                return ServiceOutcomeImpl.error((String)((String)projectValidationError.get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
            }
            hasPermission = this.permissionManager.hasPermission(VIEW_DEV_TOOLS_PERMISSION.getId(), project, user);
        }
        return ServiceOutcomeImpl.ok((Object)hasPermission);
    }

    @Override
    public ServiceOutcome<PermissionHolders> getPermissionHolders(@Nonnull Project project) {
        ApplicationUser user = this.authenticationContext.getUser();
        Option<String> validationError = this.validate(project, user);
        if (validationError.isDefined()) {
            return ServiceOutcomeImpl.error((String)((String)validationError.get()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        try {
            List<PermissionHolder> permissionHolders = this.getPermissionHolders(project, VIEW_DEV_TOOLS_PERMISSION, user);
            return ServiceOutcomeImpl.ok((Object)new PermissionHolders(this.getText(user, VIEW_DEV_TOOLS_PERMISSION.getNameKey()), permissionHolders));
        }
        catch (GenericEntityException e) {
            return ServiceOutcomeImpl.error((String)e.getLocalizedMessage(), (ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    private List<PermissionHolder> getPermissionHolders(Project project, Permissions.Permission permission, ApplicationUser user) throws GenericEntityException {
        ArrayList<PermissionHolder> permissionHolders = new ArrayList<PermissionHolder>();
        List schemes = this.permissionSchemeManager.getSchemes(project.getGenericValue());
        for (GenericValue scheme : schemes) {
            List entities = this.permissionSchemeManager.getEntities(scheme, Long.valueOf(permission.getId()));
            permissionHolders.addAll(Lists.transform((List)entities, (Function)new PermissionHolderFunction(user)));
        }
        return permissionHolders;
    }

    private Option<String> validate(Issue issue, ApplicationUser user) {
        if (issue == null) {
            return Option.some((Object)this.getText(user, "admin.project.devstatus.admin.error.null.issue"));
        }
        return Option.none();
    }

    private Option<String> validate(Project project, ApplicationUser user) {
        if (project == null) {
            return Option.some((Object)this.getText(user, "admin.project.devstatus.admin.error.null.project"));
        }
        return Option.none();
    }

    private Option<String> validate(ApplicationUser user) {
        if (user == null) {
            ApplicationUser currentUser = this.authenticationContext.getUser();
            return Option.some((Object)this.getText(currentUser, "admin.project.devstatus.admin.error.null.user"));
        }
        return Option.none();
    }

    private String getText(ApplicationUser user, String key) {
        return this.i18nHelper.getText(key);
    }

    private class PermissionHolderFunction
    implements Function<GenericValue, PermissionHolder> {
        private final ApplicationUser user;

        public PermissionHolderFunction(ApplicationUser user) {
            this.user = user;
        }

        public PermissionHolder apply(GenericValue entity) {
            SecurityType type = this.getTypeFrom(entity);
            return new PermissionHolder(type.getDisplayName(), this.getName(entity, type));
        }

        private SecurityType getTypeFrom(GenericValue entity) {
            String type = entity.getString(DefaultDevStatusPermissionService.ENTITY_TYPE);
            return DefaultDevStatusPermissionService.this.securityTypeManager.getSecurityType(type);
        }

        private String getName(GenericValue entity, SecurityType type) {
            String param = entity.getString(DefaultDevStatusPermissionService.ENTITY_PARAMETER);
            return StringUtils.isEmpty((CharSequence)param) ? DefaultDevStatusPermissionService.this.getText(this.user, "admin.common.words.anyone") : type.getArgumentDisplay(param);
        }
    }
}

