/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.plugin.devstatus.api.DevStatusDismissableService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.opensymphony.module.propertyset.PropertyException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultDevStatusDismissableService
implements DevStatusDismissableService {
    private final I18nHelper i18nHelper;
    private final UserPropertyManager userPropertyManager;

    @Inject
    public DefaultDevStatusDismissableService(@ComponentImport I18nHelper i18nHelper, @ComponentImport UserPropertyManager userPropertyManager) {
        this.i18nHelper = i18nHelper;
        this.userPropertyManager = userPropertyManager;
    }

    @Override
    public ServiceOutcome<Void> setDismissed(ApplicationUser user, String key, boolean dismissed) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        try {
            this.userPropertyManager.getPropertySet(user).setBoolean(key, dismissed);
            return ServiceOutcomeImpl.ok(null);
        }
        catch (PropertyException e) {
            return ServiceOutcomeImpl.error((String)this.getText("devstatus.dismissable.error.set"));
        }
    }

    @Override
    public ServiceOutcome<Boolean> isDismissed(ApplicationUser user, String key) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        try {
            return ServiceOutcomeImpl.ok((Object)this.userPropertyManager.getPropertySet(user).getBoolean(key));
        }
        catch (PropertyException e) {
            return ServiceOutcomeImpl.error((String)this.getText("devstatus.dismissable.error.get"));
        }
    }

    private String getText(String key) {
        return this.i18nHelper.getText(key);
    }
}

