/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.jira.plugin.devstatus.impl.ApplicationCapabilities;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Capability {
    final String name;
    final String i18nKey;
    final int weight;

    public static Set<Capability> namesToCapabilities(Set<String> capabilityNames) {
        Iterable result = Iterables.transform(capabilityNames, (Function)new Function<String, Option<Capability>>(){

            public Option<Capability> apply(@Nullable String input) {
                if (input == null) {
                    throw new IllegalArgumentException("Cannot convert null names to capabilities.");
                }
                return Capability.fromString(input);
            }
        });
        return Sets.newHashSet((Iterable)Options.flatten((Iterable)result));
    }

    public static Option<Capability> fromString(String key) {
        for (Capability c : ApplicationCapabilities.allCapabilities()) {
            if (!c.getName().equalsIgnoreCase(key)) continue;
            return Option.some((Object)c);
        }
        return Option.none();
    }

    public Capability(@Nonnull String name, @Nonnull String i18nKey) {
        this.name = name;
        this.i18nKey = i18nKey;
        this.weight = 0;
    }

    public Capability(@Nonnull String name, @Nonnull String i18nKey, int weight) {
        this.name = name;
        this.i18nKey = i18nKey;
        this.weight = weight;
    }

    public String getName() {
        return this.name;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capability that = (Capability)o;
        if (this.weight != that.weight) {
            return false;
        }
        if (!this.i18nKey.equals(that.i18nKey)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.i18nKey.hashCode();
        result = 31 * result + this.weight;
        return result;
    }

    public String toString() {
        return "Capability{name='" + this.name + '\'' + ", i18nKey='" + this.i18nKey + '\'' + ", weight='" + this.weight + '\'' + '}';
    }
}

