/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.guava.base.Function;
import com.atlassian.guava.collect.ImmutableSet;
import com.atlassian.guava.collect.Iterables;
import com.atlassian.guava.collect.Lists;
import com.atlassian.guava.collect.Sets;
import com.atlassian.jira.plugin.devstatus.impl.ApplicationCapabilities;
import com.atlassian.jira.plugin.devstatus.impl.Capability;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class SupportedApplication {
    private final String icon;
    private final String name;
    private final String application;
    private final String url;
    private final Set<Capability> incapabilities;
    private final Set<Capability> expectedCapabilities;
    private final Set<Capability> capabilities;
    private final boolean configuredForSummaryData;

    @Deprecated
    public SupportedApplication(String icon, String name, String application, String url, Set<String> incapabilities) {
        Preconditions.checkNotNull(incapabilities, (Object)"Set of incapabilities should not be null");
        this.icon = icon;
        this.name = name;
        this.application = application;
        this.url = url;
        this.expectedCapabilities = ApplicationCapabilities.UNKNOWN.expected();
        this.incapabilities = Capability.namesToCapabilities(incapabilities);
        this.capabilities = Sets.difference(this.expectedCapabilities, this.incapabilities);
        this.configuredForSummaryData = false;
    }

    public SupportedApplication(String icon, String name, String application, String url, Set<Capability> capabilities, Set<Capability> expectedCapabilities, boolean configuredForSummaryData) {
        Preconditions.checkNotNull(capabilities, (Object)"Set of actual capabilities should not be null");
        Preconditions.checkNotNull(expectedCapabilities, (Object)"Set of expected capabilities should not be null");
        this.icon = icon;
        this.name = name;
        this.application = application;
        this.url = url;
        this.capabilities = capabilities;
        this.expectedCapabilities = expectedCapabilities;
        this.incapabilities = Sets.difference(expectedCapabilities, capabilities);
        this.configuredForSummaryData = configuredForSummaryData;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getApplication() {
        return this.application;
    }

    public String getUrl() {
        return this.url;
    }

    public Set<Capability> getExpectedCapabilities() {
        return ImmutableSet.copyOf(this.expectedCapabilities);
    }

    public List<Capability> getMissingCapabilities() {
        ArrayList<Capability> capabilities1 = Lists.newArrayList(this.incapabilities);
        Collections.sort(capabilities1, new CapabilityComparator());
        return capabilities1;
    }

    public List<Capability> getCapabilities() {
        ArrayList<Capability> capabilities1 = Lists.newArrayList(this.capabilities);
        Collections.sort(capabilities1, new CapabilityComparator());
        return capabilities1;
    }

    @Deprecated
    public Set<String> getIncapabilities() {
        return Sets.newHashSet(Iterables.transform(this.incapabilities, new Function<Capability, String>(){

            @Override
            public String apply(Capability capability) {
                return capability == null ? "unknown" : capability.getName();
            }
        }));
    }

    public boolean isNeedsTwoLOConfiguration() {
        return !this.configuredForSummaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedApplication that = (SupportedApplication)o;
        if (this.application != null ? !this.application.equals(that.application) : that.application != null) {
            return false;
        }
        if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) {
            return false;
        }
        if (this.expectedCapabilities != null ? !this.expectedCapabilities.equals(that.expectedCapabilities) : that.expectedCapabilities != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        if (this.incapabilities != null ? !this.incapabilities.equals(that.incapabilities) : that.incapabilities != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return this.configuredForSummaryData == that.configuredForSummaryData;
    }

    public int hashCode() {
        int result = this.icon != null ? this.icon.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.application != null ? this.application.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.incapabilities != null ? this.incapabilities.hashCode() : 0);
        result = 31 * result + (this.expectedCapabilities != null ? this.expectedCapabilities.hashCode() : 0);
        result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
        result = 31 * result + (this.configuredForSummaryData ? 1 : 0);
        return result;
    }

    public String toString() {
        return "SupportedApplication{icon='" + this.icon + '\'' + ", name='" + this.name + '\'' + ", application='" + this.application + '\'' + ", url='" + this.url + '\'' + ", incapabilities=" + this.setToString(this.incapabilities) + ", expectedCapabilities=" + this.setToString(this.expectedCapabilities) + ", capabilities=" + this.setToString(this.capabilities) + ", configuredForSummaryData=" + this.configuredForSummaryData + '}';
    }

    private String setToString(Set<Capability> cs) {
        StringBuilder sb = new StringBuilder("{");
        sb.append(StringUtils.join((Object[])new Set[]{cs}));
        sb.append("}");
        return sb.toString();
    }

    private static class CapabilityComparator
    implements Comparator<Capability> {
        private CapabilityComparator() {
        }

        @Override
        public int compare(Capability capability, Capability capability2) {
            return capability2.getWeight() - capability.getWeight();
        }
    }
}

