/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.devstatus.analytics.AnalyticsHelper;
import com.atlassian.jira.plugin.devstatus.analytics.DevStatusAnalyticEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AnalyticsHelperImpl
implements AnalyticsHelper {
    static final String DARKFEATURE_KEY_ANALYTICS_DISABLED = "jira.plugin.devstatus.analytics.disabled";
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    @Inject
    public AnalyticsHelperImpl(@ComponentImport EventPublisher eventPublisher, @ComponentImport FeatureManager featureManager) {
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
    }

    @Override
    public boolean isAnalyticsEnabled() {
        return !this.featureManager.isEnabled(DARKFEATURE_KEY_ANALYTICS_DISABLED);
    }

    @Override
    public void publishEvent(DevStatusAnalyticEvent event) {
        if (this.isAnalyticsEnabled()) {
            this.eventPublisher.publish((Object)event);
        }
    }
}

