/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nullable;

public class UrlUtils {
    public static Iterable<Map.Entry<String, String>> repeat(final String key, Iterable<String> values) {
        return Iterables.transform(values, (Function)new Function<String, Map.Entry<String, String>>(){

            public Map.Entry<String, String> apply(@Nullable String input) {
                return new AbstractMap.SimpleImmutableEntry<String, String>(key, input);
            }
        });
    }

    public static String encode(Iterable<Map.Entry<String, String>> issueKeys) {
        return Joiner.on((String)"&").join(Iterables.transform(issueKeys, (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> input) {
                return this.encode(input.getKey()) + "=" + this.encode(input.getValue());
            }

            private String encode(String value) {
                try {
                    return URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }
}

