/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.time.FastDateFormat;

public class DateUtils {
    private static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final Pattern TWO_DIGIT_HOURS = Pattern.compile(".*[+|-][0-9][0-9]");
    private static final FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static String format(Date date) {
        return date != null ? formatter.format(date) : null;
    }

    public static Date parse(String date) {
        try {
            return date != null ? new SimpleDateFormat(FORMAT).parse(date) : null;
        }
        catch (ParseException e) {
            try {
                return new Date(Long.parseLong(date));
            }
            catch (NumberFormatException ex) {
                if (TWO_DIGIT_HOURS.matcher(date).matches()) {
                    return DateUtils.parse(date + ":00");
                }
                try {
                    return DatatypeConverter.parseDateTime((String)date).getTime();
                }
                catch (IllegalArgumentException e1) {
                    return null;
                }
            }
        }
    }
}

