/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.summary;

import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.util.DateUtils;
import com.google.common.base.Function;
import java.util.Date;

public abstract class SummaryObject
extends SummaryObjectMap {
    public static Function<? super SummaryObject, Date> TO_LAST_UPDATED = new Function<SummaryObject, Date>(){

        public Date apply(SummaryObject object) {
            return object.getLastUpdated();
        }
    };

    protected SummaryObject(SummaryObjectMap parent) {
        this.putAll(parent);
    }

    protected SummaryObject(Builder builder) {
        this.putIfNotNull("lastUpdated", builder.lastUpdated);
    }

    public Date getLastUpdated() {
        return this.getDate("lastUpdated");
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String lastUpdated;

        public T lastUpdated(Date value) {
            this.lastUpdated = DateUtils.format(value);
            return this.self();
        }

        @Deprecated
        public T lastUpdated(String value) {
            this.lastUpdated = value;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }
    }
}

