/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.review;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.detail.review.ReviewOverview;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;

public class ReviewOverviews
extends Json {
    @JsonProperty
    private final int totalCount;
    @JsonProperty
    private final List<ReviewOverview> reviews;
    @JsonProperty
    private final String url;

    private ReviewOverviews() {
        this(0, null, null);
    }

    private ReviewOverviews(int totalCount, List<ReviewOverview> branches, String url) {
        this.totalCount = totalCount;
        this.reviews = branches;
        this.url = url;
    }

    private ReviewOverviews(Builder builder) {
        this(builder.totalCount, (List<ReviewOverview>)builder.reviews.build(), builder.url);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public List<ReviewOverview> getReviews() {
        return ReviewOverviews.nonNullList(this.reviews);
    }

    public static class Builder
    extends Json.AbstractBuilder<Builder> {
        private final int totalCount;
        private final ImmutableList.Builder<ReviewOverview> reviews = ImmutableList.builder();
        private String url;

        public Builder(int totalCount) {
            this.totalCount = totalCount;
        }

        public Builder addReviews(Iterable<ReviewOverview> reviews) {
            this.reviews.addAll(reviews);
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public ReviewOverviews build() {
            return new ReviewOverviews(this);
        }
    }
}

