/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.commit;

import com.atlassian.fusion.schema.detail.BaseRepository;
import com.atlassian.fusion.schema.detail.commit.Commit;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonProperty;

public class Repository
extends BaseRepository {
    @JsonProperty
    private List<Commit> commits = ImmutableList.of();

    private Repository() {
    }

    private Repository(Builder builder) {
        super(builder);
        this.commits = builder.commits.build();
    }

    @Nonnull
    public List<Commit> getCommits() {
        return Repository.nonNullList(this.commits);
    }

    public static class Builder
    extends BaseRepository.AbstractBuilder<Builder> {
        private final ImmutableList.Builder<Commit> commits = ImmutableList.builder();

        public Builder(String name) {
            super(name);
        }

        public Builder addCommit(Commit value) {
            this.commits.add((Object)value);
            return this;
        }

        public Builder addCommits(Commit ... values) {
            return this.addCommits((Iterable<Commit>)ImmutableList.copyOf((Object[])values));
        }

        public Builder addCommits(Iterable<Commit> values) {
            this.commits.addAll(values);
            return this;
        }

        public Repository build() {
            return new Repository(this);
        }
    }
}

