/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.commit;

import com.atlassian.fusion.schema.detail.commit.BaseCommit;
import com.atlassian.fusion.schema.detail.commit.CommitBranches;
import com.atlassian.fusion.schema.detail.commit.Committer;
import com.atlassian.fusion.schema.detail.commit.File;
import com.atlassian.fusion.schema.detail.review.ReviewOverviews;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;

public class Commit
extends BaseCommit {
    @JsonProperty
    private Committer author;
    @JsonProperty
    private Integer fileCount;
    @JsonProperty
    private boolean merge;
    @JsonProperty
    private String message;
    @JsonProperty
    private List<File> files;
    @JsonProperty
    private CommitBranches branches;
    @JsonProperty
    private ReviewOverviews reviews;
    @JsonProperty
    private String createReviewUrl;

    private Commit() {
    }

    private Commit(Builder builder) {
        super(builder);
        this.author = builder.author;
        this.fileCount = builder.fileCount;
        this.merge = builder.merge;
        this.message = builder.message;
        this.files = builder.files.build();
        this.branches = builder.branches;
        this.reviews = builder.reviews;
        this.createReviewUrl = builder.createReviewUrl;
    }

    public Committer getAuthor() {
        return this.author;
    }

    public Integer getFileCount() {
        return this.fileCount;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public List<File> getFiles() {
        return Commit.nonNullList(this.files);
    }

    @Nullable
    public String getCreateReviewUrl() {
        return this.createReviewUrl;
    }

    @Nullable
    public ReviewOverviews getReviews() {
        return this.reviews;
    }

    @Nullable
    public CommitBranches getBranches() {
        return this.branches;
    }

    public static class Builder
    extends BaseCommit.Builder<Builder> {
        private final ImmutableList.Builder<File> files = ImmutableList.builder();
        private Integer fileCount;
        private boolean merge;
        private String message;
        private Committer author;
        private CommitBranches branches;
        private ReviewOverviews reviews;
        private String createReviewUrl;

        public Builder(String id) {
            super(id);
        }

        public Builder author(Committer value) {
            this.author = value;
            return this;
        }

        public Builder fileCount(int value) {
            this.fileCount = value;
            return this;
        }

        public Builder merge(boolean value) {
            this.merge = value;
            return this;
        }

        public Builder message(String value) {
            this.message = value;
            return this;
        }

        public Builder addFiles(File ... values) {
            return this.addFiles((Iterable<File>)ImmutableList.copyOf((Object[])values));
        }

        public Builder addFiles(Iterable<File> values) {
            this.files.addAll(values);
            return this;
        }

        public Builder branches(CommitBranches branches) {
            this.branches = branches;
            return this;
        }

        public Builder reviews(ReviewOverviews reviews) {
            this.reviews = reviews;
            return this;
        }

        public Builder createReviewUrl(String createReviewUrl) {
            this.createReviewUrl = createReviewUrl;
            return this;
        }

        @Override
        public Commit build() {
            return new Commit(this);
        }
    }
}

