/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.commit;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.detail.commit.File;
import com.atlassian.fusion.schema.util.DateUtils;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class BaseCommit
extends Json {
    @JsonProperty
    protected String id;
    @JsonProperty
    protected String displayId;
    @JsonProperty
    protected String authorTimestamp;
    @JsonProperty
    protected String url;

    protected BaseCommit() {
    }

    protected BaseCommit(Builder builder) {
        this.id = builder.id;
        this.displayId = builder.displayId;
        this.authorTimestamp = builder.authorTimestamp;
        this.url = builder.url;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Date getAuthorTimestamp() {
        return DateUtils.parse(this.authorTimestamp);
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public String getUrl() {
        return this.url;
    }

    public static class Builder<T extends Builder<T>>
    extends Json.AbstractBuilder<T> {
        private final ImmutableList.Builder<File> files = ImmutableList.builder();
        private final String id;
        private String authorTimestamp;
        private String displayId;
        private String url;

        public Builder(String id) {
            this.id = id;
        }

        public T authorTimestamp(Date value) {
            this.authorTimestamp = DateUtils.format(value);
            return (T)((Builder)this.self());
        }

        @Deprecated
        public T authorTimestamp(String value) {
            this.authorTimestamp = value;
            return (T)((Builder)this.self());
        }

        public T displayId(String value) {
            this.displayId = value;
            return (T)((Builder)this.self());
        }

        public T url(String value) {
            this.url = value;
            return (T)((Builder)this.self());
        }

        public BaseCommit build() {
            return new BaseCommit(this);
        }
    }
}

