/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.branch;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.common.PullRequestState;
import com.atlassian.fusion.schema.detail.User;
import com.atlassian.fusion.schema.detail.branch.PullRequestRef;
import com.atlassian.fusion.schema.detail.branch.Reviewer;
import com.atlassian.fusion.schema.util.DateUtils;
import com.atlassian.fusion.schema.util.EnumUtils;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class PullRequest
extends Json {
    @JsonProperty
    private User author;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private int commentCount;
    @JsonProperty
    private PullRequestRef source;
    @JsonProperty
    private PullRequestRef destination;
    @JsonProperty
    private List<Reviewer> reviewers;
    @JsonProperty
    private String status;
    @JsonProperty
    private String url;
    @JsonProperty
    private String lastUpdate;

    private PullRequest() {
    }

    private PullRequest(Builder builder) {
        this.id = builder.id;
        this.author = builder.author;
        this.name = builder.name;
        this.commentCount = builder.commentCount;
        this.source = builder.source;
        this.destination = builder.destination;
        this.reviewers = builder.reviewers.build();
        this.status = EnumUtils.name(builder.status);
        this.url = builder.url;
        this.lastUpdate = builder.lastUpdate;
    }

    public User getAuthor() {
        return this.author;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Date getLastUpdate() {
        return DateUtils.parse(this.lastUpdate);
    }

    public String getName() {
        return this.name;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public PullRequestRef getSource() {
        return this.source;
    }

    public PullRequestRef getDestination() {
        return this.destination;
    }

    public List<Reviewer> getReviewers() {
        return PullRequest.nonNullList(this.reviewers);
    }

    public PullRequestState getStatus() {
        return EnumUtils.valueOf(PullRequestState.class, this.status, PullRequestState.UNKNOWN);
    }

    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private final ImmutableList.Builder<Reviewer> reviewers = ImmutableList.builder();
        private final String id;
        private User author;
        private String lastUpdate;
        private String name;
        private int commentCount;
        private PullRequestRef source;
        private PullRequestRef destination;
        private PullRequestState status;
        private String url;

        public Builder(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder author(User value) {
            this.author = value;
            return this;
        }

        public Builder lastUpdate(Date value) {
            this.lastUpdate = DateUtils.format(value);
            return this;
        }

        @Deprecated
        public Builder lastUpdate(String value) {
            this.lastUpdate = value;
            return this;
        }

        public Builder commentCount(int value) {
            this.commentCount = value;
            return this;
        }

        public Builder source(PullRequestRef value) {
            this.source = value;
            return this;
        }

        public Builder destination(PullRequestRef value) {
            this.destination = value;
            return this;
        }

        public Builder status(PullRequestState value) {
            this.status = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }

        public Builder addReviewers(Iterable<Reviewer> values) {
            this.reviewers.addAll(values);
            return this;
        }

        public PullRequest build() {
            return new PullRequest(this);
        }
    }
}

