/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ext.calendar.SuppressedTipsManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="suppressedTips")
public class SuppressedTipsResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SuppressedTipsManager suppressedTipsManager;

    public SuppressedTipsResource(JiraAuthenticationContext jiraAuthenticationContext, UserPropertyManager userPropertyManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.suppressedTipsManager = new SuppressedTipsManager(userPropertyManager);
    }

    @POST
    public Response add(@FormParam(value="tipKey") String tipKey) {
        try {
            User user = this.jiraAuthenticationContext.getLoggedInUser();
            this.suppressedTipsManager.setSuppressed(tipKey, user, true);
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
    }
}

