/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.rest;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ext.calendar.HtmlCalendar;
import com.atlassian.jira.ext.calendar.HtmlCalendarConfiguration;
import com.atlassian.jira.ext.calendar.ParameterUtils;
import com.atlassian.jira.ext.calendar.model.GregorianCalendarFactory;
import com.atlassian.jira.ext.calendar.model.VersionDelegator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;
import org.ofbiz.core.entity.GenericValue;

@Path(value="calendar")
@AnonymousAllowed
public class CalendarResource {
    private static final Logger LOG = Logger.getLogger(CalendarResource.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final OfBizDelegator ofBizDelegator;
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;
    private final ConstantsManager constantsManager;
    private final VelocityManager velocityManager;
    private final ProjectManager projectManager;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final CustomFieldManager customFieldManager;

    public CalendarResource(JiraAuthenticationContext jiraAuthenticationContext, OfBizDelegator ofBizDelegator, VersionManager versionManager, PermissionManager permissionManager, ConstantsManager constantsManager, VelocityManager velocityManager, ProjectManager projectManager, SearchRequestService searchRequestService, SearchService searchService, ApplicationProperties applicationProperties, CustomFieldManager customFieldManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.ofBizDelegator = ofBizDelegator;
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
        this.constantsManager = constantsManager;
        this.velocityManager = velocityManager;
        this.projectManager = projectManager;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.customFieldManager = customFieldManager;
    }

    @GET
    @Path(value="htmlcalendar/config/datefields")
    @Produces(value={"application/json"})
    public Response getDateFields() {
        ArrayList<DateField> dateFields = new ArrayList<DateField>();
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        dateFields.add(this.createDateField("duedate", i18nHelper.getText("issue.field.duedate")));
        dateFields.add(this.createDateField("created", i18nHelper.getText("issue.field.created")));
        dateFields.add(this.createDateField("updated", i18nHelper.getText("issue.field.updated")));
        for (CustomField customField : this.customFieldManager.getCustomFieldObjects()) {
            List associatedProjects;
            CustomFieldType type = customField.getCustomFieldType();
            if (!(type instanceof DateCFType) && !(type instanceof DateTimeCFType) || (associatedProjects = customField.getAssociatedProjects()) != null && !associatedProjects.isEmpty() && !this.hasPermission(customField)) continue;
            dateFields.add(this.createDateField(customField.getId(), customField.getName()));
        }
        DateFields _dateFields = new DateFields();
        _dateFields.dateField = dateFields;
        return Response.ok((Object)_dateFields).cacheControl(CacheControl.NO_CACHE).build();
    }

    private boolean hasPermission(CustomField customField) {
        List projects = customField.getAssociatedProjects();
        for (GenericValue project : projects) {
            if (!this.permissionManager.hasPermission(10, project, this.jiraAuthenticationContext.getLoggedInUser())) continue;
            return true;
        }
        return false;
    }

    private DateField createDateField(String value, String label) {
        DateField dateField = new DateField();
        dateField.value = value;
        dateField.label = label;
        return dateField;
    }

    @GET
    @Path(value="htmlcalendar")
    @Produces(value={"text/html"})
    public Response getCalendar(@QueryParam(value="searchRequestId") Long searchRequestId, @QueryParam(value="projectId") Long projectId, @QueryParam(value="month") String month, @QueryParam(value="portletId") String portletIdString, @QueryParam(value="dateFieldName") String dateFieldName, @QueryParam(value="displayVersions") Boolean displayVersions, @QueryParam(value="numOfIssueIcons") Long numOfIssueIcons, @QueryParam(value="context") String context, @QueryParam(value="includeContainer") @DefaultValue(value="false") boolean includeContainer, @Context HttpServletRequest httpServletRequest) throws VelocityException {
        Long key;
        HtmlCalendar htmlCalendar = this.createHtmlCalendar();
        Calendar monthStart = CalendarResource.getChosenMonth(month);
        HttpSession httpSession = httpServletRequest.getSession();
        Long portletId = this.getPortletId(portletIdString);
        Long l = key = "projectTab".equals(context) ? projectId : portletId;
        if (null == monthStart) {
            monthStart = HtmlCalendarConfiguration.getBrowseMonth(httpSession, key, context);
        }
        HtmlCalendarConfiguration configuration = new HtmlCalendarConfiguration(searchRequestId, projectId, monthStart, portletId, StringUtils.isBlank((String)dateFieldName) ? "duedate" : dateFieldName, displayVersions, numOfIssueIcons, context);
        HtmlCalendarConfiguration.setDisplayVersions(httpSession, key, displayVersions, context);
        HtmlCalendarConfiguration.setBrowseMonth(httpSession, key, monthStart, context);
        Map<String, Object> velocityParams = htmlCalendar.getParameters(configuration);
        return Response.ok((Object)this.velocityManager.getEncodedBody(includeContainer ? "templates/plugins/jira/portlets/calendar/issuescalendar.vm" : "templates/plugins/jira/portlets/calendar/calendar.vm", "", this.applicationProperties.getEncoding(), velocityParams)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Long getPortletId(String portletIdString) {
        try {
            return StringUtils.isBlank((String)portletIdString) ? null : Long.valueOf(Long.parseLong(portletIdString));
        }
        catch (NumberFormatException nfe) {
            LOG.warn((Object)("Unable to convert portlet/gadget ID " + portletIdString + " to a number."), (Throwable)nfe);
            return portletIdString.hashCode();
        }
    }

    HtmlCalendar createHtmlCalendar() {
        return new HtmlCalendar(this.jiraAuthenticationContext, new VersionDelegator(this.ofBizDelegator, this.versionManager), this.permissionManager, this.constantsManager, this.projectManager, this.searchRequestService, this.searchService, this.customFieldManager);
    }

    private static Calendar getChosenMonth(String month) {
        try {
            Date monthStartDate = ParameterUtils.getMonth(month);
            return GregorianCalendarFactory.constructCalendar(monthStartDate);
        }
        catch (Exception e) {
            return null;
        }
    }

    @GET
    @Path(value="htmlcalendar/config/validate")
    @Produces(value={"application/json"})
    public Response validate(@QueryParam(value="projectOrFilterId") String projectOrFilterId, @QueryParam(value="numOfIssueIcons") String numOfIssueIcons) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (StringUtils.isBlank((String)projectOrFilterId)) {
            validationErrors.add(new ValidationError("projectOrFilterId", "gadget.common.required.query"));
        }
        try {
            Long numOfIssueIconsLong = new Long(StringUtils.defaultString((String)numOfIssueIcons));
            if (numOfIssueIconsLong < 0L) {
                validationErrors.add(new ValidationError("numOfIssueIcons", "gadget.issuescalendar.error.invalidNumberOfissues"));
            }
        }
        catch (NumberFormatException nfe) {
            validationErrors.add(new ValidationError("numOfIssueIcons", "gadget.issuescalendar.error.invalidNumberOfissues"));
        }
        if (validationErrors.isEmpty()) {
            return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder(validationErrors).build()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class DateFields {
        @XmlElement
        public List<DateField> dateField;
    }

    @XmlRootElement
    public static class DateField {
        @XmlElement
        public String label;
        @XmlElement
        public String value;
    }
}

