/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class VersionDelegator {
    private final OfBizDelegator ofBizDelegator;
    private final VersionManager versionManager;

    public VersionDelegator(OfBizDelegator ofbizDelegator, VersionManager versionManager) {
        this.ofBizDelegator = ofbizDelegator;
        this.versionManager = versionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getVersionsList(Date startDate, Date endDate, Set<Project> projects) {
        ArrayList<Version> versions = new ArrayList<Version>();
        if (projects != null && !projects.isEmpty()) {
            OfBizListIterator listIterator = null;
            try {
                GenericValue gv;
                EntityExpr condition = VersionDelegator.generateVersionSearchCondition(startDate, endDate, projects);
                listIterator = this.ofBizDelegator.findListIteratorByCondition("Version", (EntityCondition)condition);
                while (null != (gv = listIterator.next())) {
                    Long versionId = gv.getLong("id");
                    versions.add(this.versionManager.getVersion(versionId));
                }
            }
            finally {
                if (listIterator != null) {
                    listIterator.close();
                }
            }
        }
        return versions;
    }

    private static EntityExpr generateVersionSearchCondition(Date startDate, Date endDate, Set<Project> projects) {
        Timestamp t1 = new Timestamp(startDate.getTime());
        Timestamp t2 = new Timestamp(endDate.getTime());
        EntityExpr r1 = new EntityExpr("releasedate", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)t1);
        EntityExpr r2 = new EntityExpr("releasedate", EntityOperator.LESS_THAN_EQUAL_TO, (Object)t2);
        EntityExpr releaseDateCondition = new EntityExpr((EntityCondition)r1, EntityOperator.AND, (EntityCondition)r2);
        ArrayList<EntityExpr> projectIdsConditionList = new ArrayList<EntityExpr>();
        for (Project project : projects) {
            projectIdsConditionList.add(new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId()));
        }
        EntityExprList projectIdsCondition = new EntityExprList(projectIdsConditionList, EntityOperator.OR);
        return new EntityExpr((EntityCondition)releaseDateCondition, EntityOperator.AND, (EntityCondition)projectIdsCondition);
    }
}

