/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.jira.ext.calendar.ParameterUtils;
import com.atlassian.jira.ext.calendar.model.DateFieldProvider;
import com.atlassian.jira.ext.calendar.model.DayEvents;
import com.atlassian.jira.ext.calendar.model.GregorianCalendarFactory;
import com.atlassian.jira.ext.calendar.model.WeekEvents;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.version.Version;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class MonthEvents {
    private static final Logger log = Logger.getLogger((String)MonthEvents.class.getName());
    private DayEvents[] dayEventList;
    private WeekEvents[] weekEventList;
    private int paddingDaysStart;
    private final Date previousMonthDate;
    private final Date monthStartDate;
    private final Date nextMonthDate;

    public MonthEvents(List issueList, List versionList, Calendar monthStart, DateFieldProvider dateFieldProvider) {
        this.monthStartDate = monthStart.getTime();
        this.previousMonthDate = ParameterUtils.cloneAddMonths(monthStart, -1).getTime();
        this.nextMonthDate = ParameterUtils.cloneAddMonths(monthStart, 1).getTime();
        this.paddingDaysStart = this.modulo(monthStart.get(7) - monthStart.getFirstDayOfWeek(), 7) + 1;
        Calendar calendarStart = (Calendar)monthStart.clone();
        calendarStart.add(6, -this.paddingDaysStart);
        int weeksInMonth = monthStart.getActualMaximum(4);
        this.dayEventList = MonthEvents.createDays(calendarStart, weeksInMonth * 7);
        for (Issue issue : issueList) {
            net.fortuna.ical4j.model.Date date = dateFieldProvider.getDate(issue);
            Calendar issueDueCal = GregorianCalendarFactory.constructCalendar(date);
            int dayOfMonth = this.getDayOfMonth(date);
            int dayEventIndex = dayOfMonth + this.paddingDaysStart - 2;
            if (!MonthEvents.isSameMonth(monthStart, issueDueCal) || dayEventIndex >= this.dayEventList.length) continue;
            this.dayEventList[dayEventIndex].addIssue(issue);
        }
        for (Version version : versionList) {
            Calendar versionRelCal = GregorianCalendarFactory.constructCalendar(version.getReleaseDate());
            int dayOfMonth = this.getDayOfMonth(version.getReleaseDate());
            if (!MonthEvents.isSameMonth(monthStart, versionRelCal) || dayOfMonth + this.paddingDaysStart - 2 >= this.dayEventList.length) continue;
            this.dayEventList[dayOfMonth + this.paddingDaysStart - 2].addVersion(version);
        }
        this.weekEventList = new WeekEvents[weeksInMonth];
        for (int i = 0; i < this.weekEventList.length; ++i) {
            this.weekEventList[i] = new WeekEvents(i);
            for (int j = 0; j < 7; ++j) {
                this.weekEventList[i].setDay(j, this.dayEventList[i * 7 + j]);
            }
        }
    }

    public int getDayOfMonth(Date date) {
        return GregorianCalendarFactory.constructCalendar(date).get(5);
    }

    private static DayEvents[] createDays(Calendar startDay, int noOfDays) {
        DayEvents[] dayList = new DayEvents[noOfDays];
        for (int i = 0; i < noOfDays; ++i) {
            Calendar dayCalendar = (Calendar)startDay.clone();
            dayCalendar.add(6, i + 1);
            dayList[i] = new DayEvents(dayCalendar);
        }
        return dayList;
    }

    private static boolean isSameYear(Calendar d1, Calendar d2) {
        return d1.get(1) == d2.get(1);
    }

    private static boolean isSameMonth(Calendar d1, Calendar d2) {
        return MonthEvents.isSameYear(d1, d2) && d1.get(2) == d2.get(2);
    }

    public static boolean isSameDay(Calendar d1, Calendar d2) {
        return MonthEvents.isSameYear(d1, d2) && d1.get(6) == d2.get(6);
    }

    public DayEvents[] getDayEventList() {
        return this.dayEventList;
    }

    public WeekEvents[] getWeekEventList() {
        return this.weekEventList;
    }

    public Date getMonthStartDate() {
        return this.monthStartDate;
    }

    public Date getNextMonthDate() {
        return this.nextMonthDate;
    }

    public Integer getNextMonthOfYear() {
        return this.getMonthOfYear(this.nextMonthDate);
    }

    public Date getPreviousMonthDate() {
        return this.previousMonthDate;
    }

    public Integer getPreviousMonthOfYear() {
        return this.getMonthOfYear(this.previousMonthDate);
    }

    public Integer getMonthOfYear() {
        return this.getMonthOfYear(this.monthStartDate);
    }

    public Integer getMonthOfYear(Date date) {
        return new Integer(GregorianCalendarFactory.constructCalendar(date).get(2));
    }

    private int modulo(int x, int y) {
        int result = x % y;
        if (x < 0) {
            return result + y;
        }
        return result;
    }
}

