/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.jira.ext.calendar.model.DateFieldProvider;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.priority.Priority;
import java.util.Comparator;
import net.fortuna.ical4j.model.Date;

public class IssueComparator
implements Comparator<Issue> {
    private DateFieldProvider dateFieldProvider;

    public IssueComparator(String dateFieldName) {
        this.dateFieldProvider = new DateFieldProvider(dateFieldName);
    }

    @Override
    public int compare(Issue issue1, Issue issue2) {
        int issueComparison;
        int dueDateComparison;
        if (issue1 == issue2) {
            return 0;
        }
        Date issue1Date = this.dateFieldProvider.getDate(issue1);
        Date issue2Date = this.dateFieldProvider.getDate(issue2);
        if (null == issue1Date && null != issue2Date) {
            return -1;
        }
        if (null != issue1Date && null == issue2Date) {
            return 1;
        }
        if (null != issue1Date && null != issue2Date && issue1Date != issue2Date && (dueDateComparison = issue1Date.compareTo(issue2Date)) != 0) {
            return dueDateComparison;
        }
        Priority issue1Priority = issue1.getPriorityObject();
        Priority issue2Priority = issue2.getPriorityObject();
        if (null == issue1Priority && null != issue2Priority) {
            return -1;
        }
        if (null != issue1Priority && null == issue2Priority) {
            return 1;
        }
        if (null != issue1Priority && null != issue2Priority && issue1Priority != issue2Priority && (issueComparison = issue1Priority.compareTo((Object)issue2Priority)) != 0) {
            return issueComparison;
        }
        return issue1.getId().compareTo(issue2.getId());
    }
}

