/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.version.Version;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DayEvents {
    private final Calendar today;
    private List issueList;
    private List versionList;

    public DayEvents(Calendar today) {
        this.today = today;
        this.issueList = new ArrayList();
        this.versionList = new ArrayList();
    }

    public void addIssue(Issue issue) {
        this.issueList.add(issue);
    }

    public void addVersion(Version version) {
        this.versionList.add(version);
    }

    public Calendar getToday() {
        return this.today;
    }

    public Date getTodayDate() {
        return this.today.getTime();
    }

    public List getIssues() {
        return this.issueList;
    }

    public List getFirstXIssues(int x) {
        return this.issueList.subList(0, Math.min(x, this.issueList.size()));
    }

    public int getDayOfMonth() {
        return this.today.get(5);
    }

    public int getMonthOfYear() {
        return this.today.get(2);
    }

    public Integer getDayOfWeek() {
        return new Integer(this.today.get(7));
    }

    public Integer getNoOfIssues() {
        return new Integer(this.issueList.size());
    }

    public List getVersions() {
        return this.versionList;
    }

    public Integer getNoOfVersions() {
        return new Integer(this.versionList.size());
    }
}

