/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.I18nHelper;
import java.sql.Timestamp;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import org.apache.log4j.Logger;

public class DateFieldProvider {
    private static final Logger log = Logger.getLogger((String)DateFieldProvider.class.getName());
    private String dateFieldName;

    public DateFieldProvider(String dateFieldName) {
        this.dateFieldName = dateFieldName;
    }

    public String getDateFieldName() {
        return this.dateFieldName;
    }

    public String getI18nDateFieldName() {
        I18nHelper i18n = ComponentManager.getInstance().getJiraAuthenticationContext().getI18nHelper();
        if (this.dateFieldName != null) {
            CustomField customField;
            if (this.dateFieldName.equals("duedate")) {
                return i18n.getText("issue.field.duedate");
            }
            if (this.dateFieldName.equals("created")) {
                return i18n.getText("issue.field.created");
            }
            if (this.dateFieldName.equals("updated")) {
                return i18n.getText("issue.field.updated");
            }
            if (this.dateFieldName.startsWith("customfield_") && (customField = ManagerFactory.getCustomFieldManager().getCustomFieldObject(this.dateFieldName)) != null) {
                return customField.getName();
            }
        }
        return this.dateFieldName;
    }

    public boolean isDateTimeField() {
        if (this.dateFieldName.startsWith("customfield_")) {
            CustomField customField = ManagerFactory.getCustomFieldManager().getCustomFieldObject(this.dateFieldName);
            return customField.getCustomFieldType() instanceof DateTimeCFType;
        }
        return false;
    }

    public Date getDate(Issue issue) {
        if (this.dateFieldName != null) {
            if (this.dateFieldName.equals("duedate")) {
                return issue.getDueDate() != null ? new Date(issue.getDueDate()) : null;
            }
            if (this.dateFieldName.equals("created")) {
                return issue.getCreated() != null ? new DateTime(issue.getCreated()) : null;
            }
            if (this.dateFieldName.equals("updated")) {
                return issue.getUpdated() != null ? new DateTime(issue.getUpdated()) : null;
            }
            if (this.dateFieldName.startsWith("customfield_")) {
                CustomFieldType cfType;
                Object value;
                Timestamp timestamp = null;
                CustomField customField = ManagerFactory.getCustomFieldManager().getCustomFieldObject(this.dateFieldName);
                if (customField != null && (value = customField.getValue(issue)) instanceof Timestamp) {
                    timestamp = (Timestamp)value;
                }
                if ((cfType = customField.getCustomFieldType()) instanceof DateTimeCFType) {
                    return timestamp != null ? new DateTime(timestamp) : null;
                }
                return timestamp != null ? new Date(timestamp) : null;
            }
        }
        log.warn((Object)("Date field '" + this.dateFieldName + "' was not found, displaying 'dueDate'"));
        return issue.getDueDate() != null ? new Date(issue.getDueDate()) : null;
    }
}

