/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.core.util.DateUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.ext.calendar.model.DateFieldProvider;
import com.atlassian.jira.ext.calendar.model.InvalidFilterSearchRequestException;
import com.atlassian.jira.ext.calendar.model.InvalidProjectSearchRequestException;
import com.atlassian.jira.ext.calendar.model.IssueComparator;
import com.atlassian.jira.ext.calendar.model.VersionComparator;
import com.atlassian.jira.ext.calendar.model.VersionDelegator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class CalendarSearchRequest {
    private static final Long DEFAULT_START_OFFSET = -28L * DateUtils.DAY_MILLIS;
    private static final Long DEFAULT_END_OFFSET = 84L * DateUtils.DAY_MILLIS;
    private final User user;
    private final SearchRequest projectOrFilterIdSearchRequest;
    private final SearchRequest search;
    private final DateFieldProvider dateFieldProvider;
    private final Date startDate;
    private final Date endDate;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final CustomFieldManager customFieldManager;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private SortedSet<Issue> issues;
    private SortedSet<Version> versions;
    private Long projectId;

    public CalendarSearchRequest(User user, Long searchIdentifier, Long projectId, String dateFieldName, Long startOffset, Long endOffset, VersionDelegator versionDelegator, PermissionManager permissionManager, ProjectManager projectManager, SearchRequestService searchRequestService, SearchService searchService, CustomFieldManager customFieldManager) throws InvalidFilterSearchRequestException, InvalidProjectSearchRequestException, SearchException {
        this(user, searchIdentifier, projectId, dateFieldName, new Date(System.currentTimeMillis() + (null == startOffset ? DEFAULT_START_OFFSET : startOffset)), new Date(System.currentTimeMillis() + (null == endOffset ? DEFAULT_END_OFFSET : endOffset)), versionDelegator, permissionManager, projectManager, searchRequestService, searchService, customFieldManager);
    }

    public CalendarSearchRequest(User user, Long searchIdentifier, Long projectId, String dateFieldName, Date startDate, Date endDate, VersionDelegator versionDelegator, PermissionManager permissionManager, ProjectManager projectManager, SearchRequestService searchRequestService, SearchService searchService, CustomFieldManager customFieldManager) throws InvalidFilterSearchRequestException, InvalidProjectSearchRequestException, SearchException {
        long now = System.currentTimeMillis();
        this.user = user;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.dateFieldProvider = new DateFieldProvider(dateFieldName);
        this.startDate = null == startDate ? new Date(now + DEFAULT_START_OFFSET) : startDate;
        this.endDate = null == endDate ? new Date(now + DEFAULT_END_OFFSET) : endDate;
        this.issues = new TreeSet<Issue>(new IssueComparator(dateFieldName));
        this.versions = new TreeSet<Version>(new VersionComparator());
        this.projectOrFilterIdSearchRequest = this.getSearchForProjectOrSearchId(searchIdentifier, projectId, user);
        this.search = new SearchRequest(this.projectOrFilterIdSearchRequest.getQuery());
        this.projectId = projectId;
        this.customFieldManager = customFieldManager;
        this.search.setName(this.projectOrFilterIdSearchRequest.getName());
        this.addConstraintToSearchRequest(this.search, dateFieldName, this.startDate, this.endDate);
        this.orderByDateFieldAndPriority(this.search, dateFieldName);
        this.initializeIssues();
        this.initializeVersions(versionDelegator);
    }

    protected SearchRequest getSearchForProjectOrSearchId(Long searchIdentifier, Long projectId, User user) throws InvalidFilterSearchRequestException, InvalidProjectSearchRequestException {
        if (searchIdentifier != null) {
            SearchRequest tempSearch = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user), searchIdentifier);
            if (tempSearch == null) {
                throw new InvalidFilterSearchRequestException("Invalid searchId given " + searchIdentifier);
            }
            SearchRequest retSearch = new SearchRequest(tempSearch);
            retSearch.setName(tempSearch.getName());
            return retSearch;
        }
        if (projectId != null) {
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                throw new InvalidFilterSearchRequestException("Invalid projectId given " + projectId);
            }
            return this.createProjectSearchRequest(projectId, project.getName());
        }
        throw new InvalidProjectSearchRequestException("No SearchId or ProjectId specified.");
    }

    private void initializeIssues() throws SearchException {
        SearchResults results = this.getResults();
        for (Issue issue : results.getIssues()) {
            if (!this.isCalendarableIssue(issue)) continue;
            this.issues.add(issue);
        }
    }

    private void initializeVersions(VersionDelegator versionDelegator) {
        final HashSet<Project> allowedProjects = new HashSet<Project>(this.permissionManager.getProjectObjects(10, this.user));
        HashSet<Object> projects = null;
        if (null == this.projectId) {
            if (StringUtils.isBlank((String)this.projectOrFilterIdSearchRequest.getQuery().getQueryString()) || !this.projectOrFilterIdSearchRequest.getQuery().getQueryString().contains("project")) {
                projects = new HashSet<Project>(allowedProjects);
            } else {
                QueryContext queryContext = this.searchService.getSimpleQueryContext(this.user, this.projectOrFilterIdSearchRequest.getQuery());
                Collection queryProjects = queryContext.getProjectIssueTypeContexts();
                HashSet selectedProjects = new HashSet();
                if (null != queryProjects) {
                    for (Object contextObject : queryProjects) {
                        selectedProjects.addAll(Collections2.filter((Collection)Collections2.transform((Collection)((QueryContext.ProjectIssueTypeContexts)contextObject).getProjectIdInList(), (Function)new Function<Long, Project>(){

                            public Project apply(Long projectId) {
                                return CalendarSearchRequest.this.projectManager.getProjectObj(projectId);
                            }
                        }), (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<Project>(){

                            public boolean apply(Project p) {
                                return allowedProjects.contains(p);
                            }
                        })));
                    }
                }
                projects = new HashSet(selectedProjects);
            }
        } else {
            Project targetProject = this.projectManager.getProjectObj(this.projectId);
            if (this.isProjectInAllowedList(allowedProjects, targetProject)) {
                projects = new HashSet<Project>(Arrays.asList(targetProject));
            }
        }
        this.versions.addAll(versionDelegator.getVersionsList(this.startDate, this.endDate, projects));
    }

    private boolean isProjectInAllowedList(Set<Project> allowedProjects, Project targetProject) {
        for (Project allowedProject : allowedProjects) {
            if (!StringUtils.equalsIgnoreCase((String)allowedProject.getKey(), (String)targetProject.getKey())) continue;
            return true;
        }
        return false;
    }

    private String getClauseNameOfCustomField(String customFieldIdString) {
        return "cf[" + customFieldIdString.substring("customfield_".length()) + "]";
    }

    private Date truncate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).setTimeZone(((TimeZoneManager)ComponentManager.getComponentInstanceOfType(TimeZoneManager.class)).getLoggedInUserTimeZone());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date truncatedDate = calendar.getTime();
        return truncatedDate;
    }

    private void addConstraintToSearchRequest(SearchRequest sr, String dateFieldName, Date start, Date end) {
        Clause whereClause;
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        if (StringUtils.equals((String)"duedate", (String)dateFieldName)) {
            whereClause = jqlQueryBuilder.where().dueBetween(this.truncate(start), this.truncate(end)).buildQuery().getWhereClause();
        } else if (StringUtils.equals((String)"created", (String)dateFieldName)) {
            whereClause = jqlQueryBuilder.where().createdBetween(start, end).buildQuery().getWhereClause();
        } else if (StringUtils.equals((String)"updated", (String)dateFieldName)) {
            whereClause = jqlQueryBuilder.where().updatedBetween(start, end).buildQuery().getWhereClause();
        } else {
            String clauseName = this.getClauseNameOfCustomField(dateFieldName);
            CustomField customField = this.customFieldManager.getCustomFieldObject(dateFieldName);
            CustomFieldType type = null == customField ? null : customField.getCustomFieldType();
            whereClause = type instanceof DateCFType ? jqlQueryBuilder.where().addDateCondition(clauseName, Operator.GREATER_THAN_EQUALS, this.truncate(start)).and().addDateCondition(clauseName, Operator.LESS_THAN_EQUALS, this.truncate(end)).buildQuery().getWhereClause() : jqlQueryBuilder.where().addDateCondition(clauseName, Operator.GREATER_THAN_EQUALS, start).and().addDateCondition(clauseName, Operator.LESS_THAN_EQUALS, end).buildQuery().getWhereClause();
        }
        if (null != whereClause) {
            Query searchQuery = sr.getQuery();
            if (null != searchQuery.getWhereClause()) {
                sr.setQuery((Query)new QueryImpl((Clause)new AndClause(new Clause[]{searchQuery.getWhereClause(), whereClause}), searchQuery.getOrderByClause(), null));
            } else {
                sr.setQuery(jqlQueryBuilder.buildQuery());
            }
        }
    }

    private void orderByDateFieldAndPriority(SearchRequest sr, String dateFieldName) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)sr.getQuery());
        JqlOrderByBuilder jqlOrderByBuilder = jqlQueryBuilder.orderBy();
        if (StringUtils.equals((String)"duedate", (String)dateFieldName)) {
            jqlOrderByBuilder = jqlOrderByBuilder.dueDate(SortOrder.DESC);
        } else if (StringUtils.equals((String)"created", (String)dateFieldName)) {
            jqlOrderByBuilder = jqlOrderByBuilder.createdDate(SortOrder.DESC);
        } else if (StringUtils.equals((String)"updated", (String)dateFieldName)) {
            jqlOrderByBuilder = jqlOrderByBuilder.updatedDate(SortOrder.DESC);
        } else {
            jqlOrderByBuilder.add(this.getClauseNameOfCustomField(dateFieldName), SortOrder.DESC);
        }
        jqlOrderByBuilder.priority(SortOrder.ASC);
        sr.setQuery(jqlQueryBuilder.buildQuery());
    }

    private SearchRequest createProjectSearchRequest(Long projectId, String projectName) {
        SearchRequest sr = new SearchRequest(JqlQueryBuilder.newBuilder().where().project(new Long[]{projectId}).buildQuery());
        sr.setName(projectName);
        return sr;
    }

    public SearchRequest getSearch() {
        return this.search;
    }

    public DateFieldProvider getDateFieldProvider() {
        return this.dateFieldProvider;
    }

    public SearchResults getResults() throws SearchException {
        SearchProvider searcher = this.getSearchProvider();
        return searcher.search(this.search.getQuery(), this.user, PagerFilter.getUnlimitedFilter());
    }

    protected SearchProvider getSearchProvider() {
        return ComponentManager.getInstance().getSearchProvider();
    }

    public boolean isCalendarableIssue(Issue issue) {
        return issue != null && this.dateFieldProvider.getDate(issue) != null;
    }

    public boolean isCalendarableVersion(Version version) {
        long nowInMillis = new Date().getTime();
        long startOffset = this.startDate.getTime() - nowInMillis;
        long endOffset = this.endDate.getTime() - nowInMillis;
        return version != null && version.getReleaseDate() != null && CalendarSearchRequest.isDateInRange(version.getReleaseDate(), startOffset, endOffset);
    }

    private static boolean isDateInRange(Date date, long startOffset, long endOffset) {
        long now = System.currentTimeMillis();
        return date.getTime() >= now + startOffset && date.getTime() <= now + endOffset;
    }

    public SortedSet getIssues() {
        return this.issues;
    }

    public SortedSet getVersions() {
        return this.versions;
    }

    public SearchRequest getSearchRequestForDay(Date date) {
        String dateFieldName;
        Date truncatedDate = date;
        if (truncatedDate != null) {
            truncatedDate = org.apache.commons.lang.time.DateUtils.truncate((Date)date, (int)5);
        }
        boolean exclusive = (dateFieldName = this.dateFieldProvider.getDateFieldName()).equals("duedate") || dateFieldName.startsWith("customfield_") && !this.dateFieldProvider.isDateTimeField();
        Date dayStartDate = truncatedDate;
        Date dayEndDate = exclusive ? truncatedDate : new Date(truncatedDate.getTime() + DateUtils.DAY_MILLIS);
        SearchRequest searchRequestForDay = new SearchRequest(this.projectOrFilterIdSearchRequest);
        this.addConstraintToSearchRequest(searchRequestForDay, dateFieldName, dayStartDate, dayEndDate);
        return searchRequestForDay;
    }

    public String getQueryString() {
        return this.projectOrFilterIdSearchRequest.isLoaded() ? "?mode=hide&requestId=" + this.projectOrFilterIdSearchRequest.getId() : "?reset=true&" + this.searchService.getQueryString(this.user, this.projectOrFilterIdSearchRequest.getQuery());
    }
}

