/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.model;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.ext.calendar.model.CalendarSearchRequest;
import com.atlassian.jira.ext.calendar.model.DateFieldProvider;
import com.atlassian.jira.ext.calendar.model.GregorianCalendarFactory;
import com.atlassian.jira.ext.calendar.model.MonthEvents;
import com.atlassian.jira.issue.Issue;
import com.google.common.base.Objects;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.CategoryList;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.log4j.Logger;

public class CalendarFactory {
    private static final Logger LOG = Logger.getLogger(CalendarFactory.class);
    private final CalendarSearchRequest search;
    private final DateFieldProvider dateFieldProvider;
    private final TimeZone timezone;

    public CalendarFactory(CalendarSearchRequest search, String dateFieldName) {
        this.search = search;
        this.dateFieldProvider = new DateFieldProvider(dateFieldName);
        this.timezone = (TimeZone)Objects.firstNonNull((Object)TimeZoneRegistryFactory.getInstance().createRegistry().getTimeZone(TimeZone.getDefault().getID()), (Object)TimeZone.getDefault());
    }

    public Calendar createICalendarFromSearch(boolean showReleaseDates) {
        ComponentList calendarComponents = new ComponentList();
        calendarComponents.addAll(this.mapIssuesAsEvents());
        if (showReleaseDates) {
            calendarComponents.addAll(this.mapVersionsAsEvents());
        }
        return this.createCalendar(calendarComponents);
    }

    public MonthEvents createMonth(java.util.Calendar monthStart) {
        return new MonthEvents(new ArrayList(this.getIssues()), new ArrayList(this.getVersions()), monthStart, this.dateFieldProvider);
    }

    public MonthEvents createCurrentMonth() {
        java.util.Calendar calendar = GregorianCalendarFactory.constructCalendar();
        int dom = calendar.get(5) - 1;
        calendar.add(5, -dom);
        return this.createMonth(calendar);
    }

    private List mapIssuesAsEvents() {
        ArrayList<Component> eventList = new ArrayList<Component>();
        for (Issue issue : this.getIssues()) {
            eventList.add(this.createCalendarIssue(issue));
        }
        return eventList;
    }

    protected Set getIssues() {
        return this.search.getIssues();
    }

    protected Set getVersions() {
        return this.search.getVersions();
    }

    protected TimeZone getTimeZone() {
        return this.timezone;
    }

    private List mapVersionsAsEvents() {
        ArrayList<Component> eventList = new ArrayList<Component>();
        for (com.atlassian.jira.project.version.Version version : this.getVersions()) {
            eventList.add(this.createCalendarVersion(version));
        }
        return eventList;
    }

    private Component createCalendarIssue(Issue issue) {
        Date beginDate = this.dateFieldProvider.getDate(issue);
        Date endDate = null;
        endDate = beginDate instanceof DateTime ? new DateTime(beginDate.getTime() + 1800000L) : new Date(beginDate.getTime() + 86400000L);
        VEvent event = new VEvent(beginDate, endDate, this.getTitle(issue));
        PropertyList eventProperties = event.getProperties();
        if (beginDate instanceof DateTime) {
            eventProperties.getProperty("DTSTART").getParameters().add(Value.DATE_TIME);
        } else {
            eventProperties.getProperty("DTSTART").getParameters().add(Value.DATE);
        }
        if (endDate instanceof DateTime) {
            eventProperties.getProperty("DTEND").getParameters().add(Value.DATE_TIME);
        } else {
            eventProperties.getProperty("DTEND").getParameters().add(Value.DATE);
        }
        eventProperties.add(new Uid("issue-" + issue.getId() + "@" + this.getBaseUrl()));
        eventProperties.add(this.getDescription(issue));
        eventProperties.add(new Categories(new CategoryList("Issues")));
        eventProperties.add(Status.VEVENT_CONFIRMED);
        eventProperties.add(this.getUrl(issue));
        try {
            eventProperties.add(this.getAttendee(issue));
        }
        catch (Exception e) {
            LOG.error((Object)"CalendarFactory.createCalendarIssue(Issue):Component Error creating attendee.", (Throwable)e);
        }
        return event;
    }

    private Description getDescription(Issue issue) {
        return new Description(issue.getDescription());
    }

    private String getTitle(Issue issue) {
        return "[" + issue.getKey() + "] " + issue.getSummary();
    }

    private Url getUrl(Issue issue) {
        try {
            String baseUrl = this.getBaseUrl();
            return new Url(new URI(baseUrl + "/browse/" + issue.getKey()));
        }
        catch (URISyntaxException use) {
            return new Url();
        }
    }

    protected String getBaseUrl() {
        return ManagerFactory.getApplicationProperties().getString("jira.baseurl");
    }

    private Component createCalendarVersion(com.atlassian.jira.project.version.Version version) {
        if (version.getReleaseDate() != null) {
            Date beginDate = new Date(version.getReleaseDate());
            Date endDate = new Date(beginDate.getTime() + 86400000L);
            VEvent event = new VEvent(beginDate, endDate, this.getTitle(version));
            PropertyList eventProperties = event.getProperties();
            if (beginDate instanceof DateTime) {
                eventProperties.getProperty("DTSTART").getParameters().add(Value.DATE_TIME);
            } else {
                eventProperties.getProperty("DTSTART").getParameters().add(Value.DATE);
            }
            if (endDate instanceof DateTime) {
                eventProperties.getProperty("DTEND").getParameters().add(Value.DATE_TIME);
            } else {
                eventProperties.getProperty("DTEND").getParameters().add(Value.DATE);
            }
            eventProperties.add(new Uid("version-" + version.getId() + "@" + this.getBaseUrl()));
            eventProperties.add(this.getDescription(version));
            eventProperties.add(new Categories(new CategoryList("Issues")));
            eventProperties.add(Status.VEVENT_CONFIRMED);
            return event;
        }
        return null;
    }

    private Attendee getAttendee(Issue issue) throws URISyntaxException {
        User user = issue.getAssignee();
        ParameterList paramList = new ParameterList();
        paramList.add(new Cn(user.getDisplayName()));
        return new Attendee(paramList, "mailto:" + user.getEmailAddress());
    }

    private String getTitle(com.atlassian.jira.project.version.Version version) {
        return "[" + version.getProjectObject().getName() + "] " + version.getName();
    }

    private Description getDescription(com.atlassian.jira.project.version.Version version) {
        return new Description(version.getDescription());
    }

    private Calendar createCalendar(ComponentList calendarComponents) {
        PropertyList calendarProperties = new PropertyList();
        calendarProperties.add(new ProdId("-//JIRA//iCal4j 1.0//EN"));
        calendarProperties.add(Version.VERSION_2_0);
        calendarProperties.add(CalScale.GREGORIAN);
        calendarProperties.add(Method.PUBLISH);
        calendarProperties.add(new XProperty("X-WR-TIMEZONE", new ParameterList(), this.timezone.getID()));
        return new Calendar(calendarProperties, calendarComponents);
    }
}

