/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar.condition;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ext.calendar.SuppressedTipsManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.apache.log4j.Logger;

public class TipSuppressedCondition
implements Condition {
    private static final Logger log = Logger.getLogger(TipSuppressedCondition.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SuppressedTipsManager suppressedTipsManager;
    private String tipKey;

    public TipSuppressedCondition(JiraAuthenticationContext jiraAuthenticationContext, UserPropertyManager userPropertyManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.suppressedTipsManager = new SuppressedTipsManager(userPropertyManager);
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.tipKey = params.get("tipKey");
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        User user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user == null) {
            return false;
        }
        try {
            return this.suppressedTipsManager.isSuppressed(this.tipKey, user);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Unable to check if the info tip '" + this.tipKey + "' has been suppressed or not."), (Throwable)e);
            return false;
        }
    }
}

