/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserPropertyManager;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.module.propertyset.PropertySet;

public class SuppressedTipsManager {
    private static final String KEY_NAMESPACE = "jira.user.suppressedTips.";
    private static final ImmutableSet<String> KEY_WHITE_LIST = ImmutableSet.of((Object)"browseProjectCalendarTab");
    private final UserPropertyManager userPropertyManager;

    public SuppressedTipsManager(UserPropertyManager userPropertyManager) {
        this.userPropertyManager = userPropertyManager;
    }

    public boolean isSuppressed(String tipKey, User user) {
        if (KEY_WHITE_LIST.contains((Object)tipKey)) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
            return propertySet.getBoolean(KEY_NAMESPACE + tipKey);
        }
        throw new IllegalArgumentException("Invalid tip key '" + tipKey + "'.");
    }

    public void setSuppressed(String tipKey, User user, boolean suppressed) {
        if (!KEY_WHITE_LIST.contains((Object)tipKey)) {
            throw new IllegalArgumentException("Invalid tip key '" + tipKey + "'.");
        }
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(KEY_NAMESPACE + tipKey, suppressed);
    }
}

