/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar;

import com.atlassian.core.util.DateUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ParameterUtils {
    static final DateFormat format = new SimpleDateFormat("MMyyyy");

    public static boolean getBoolean(String booleanStr) {
        if (booleanStr == null) {
            return true;
        }
        return Boolean.valueOf(booleanStr);
    }

    public static Long getLong(String paramStr) {
        try {
            return new Long(paramStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getDuration(String durStr) {
        if (durStr != null) {
            try {
                return new Long(DateUtils.getDuration((String)durStr) * DateUtils.SECOND_MILLIS);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Date getMonth(String monthStr) {
        try {
            return format.parse(monthStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date endOfMonth(Date month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(month);
        calendar.set(5, calendar.getMaximum(5));
        calendar.set(11, calendar.getMaximum(11));
        calendar.set(12, calendar.getMaximum(12));
        calendar.set(13, calendar.getMaximum(13));
        calendar.set(14, calendar.getMaximum(14));
        return calendar.getTime();
    }

    public static String getMonthStr(Date month) {
        return format.format(month);
    }

    public static Calendar cloneAddMonths(Calendar cal, int months) {
        Calendar newMonthCal = (Calendar)cal.clone();
        newMonthCal.add(2, months);
        return newMonthCal;
    }

    public static boolean isProject(String value) {
        return ParameterUtils.isBaseMethod(value, "project-");
    }

    public static boolean isFilter(String value) {
        return ParameterUtils.isBaseMethod(value, "filter-");
    }

    public static Long getProjectId(String value) {
        if (ParameterUtils.isProject(value)) {
            return new Long(value.substring(8));
        }
        return null;
    }

    public static Long getFilterId(String value) {
        if (ParameterUtils.isFilter(value)) {
            return new Long(value.substring(7));
        }
        return null;
    }

    private static boolean isBaseMethod(String value, String prefix) {
        return value != null && value.startsWith(prefix);
    }
}

