/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.ext.calendar.ParameterUtils;
import com.atlassian.jira.ext.calendar.model.CalendarFactory;
import com.atlassian.jira.ext.calendar.model.CalendarSearchRequest;
import com.atlassian.jira.ext.calendar.model.VersionDelegator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ValidationException;
import org.apache.log4j.Logger;

public class ICalendarServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(ICalendarServlet.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final SearchRequestService searchRequestService;
    private final OfBizDelegator ofBizDelegator;
    private final VersionManager versionManager;
    private final SearchService searchService;
    private final CustomFieldManager customFieldManager;

    public ICalendarServlet(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, ProjectManager projectManager, SearchRequestService searchRequestService, OfBizDelegator ofBizDelegator, VersionManager versionManager, SearchService searchService, CustomFieldManager customFieldManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.searchRequestService = searchRequestService;
        this.ofBizDelegator = ofBizDelegator;
        this.versionManager = versionManager;
        this.searchService = searchService;
        this.customFieldManager = customFieldManager;
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CalendarSearchRequest calSearch;
        User user = this.jiraAuthenticationContext.getLoggedInUser();
        Long searchId = ParameterUtils.getLong(req.getParameter("searchRequestId"));
        Long projectId = ParameterUtils.getLong(req.getParameter("projectId"));
        Long startOffset = ParameterUtils.getDuration(req.getParameter("startOffset")) != null ? Long.valueOf(-ParameterUtils.getDuration(req.getParameter("startOffset")).longValue()) : null;
        Long endOffset = ParameterUtils.getDuration(req.getParameter("endOffset"));
        String dateFieldName = req.getParameter("dateFieldName");
        boolean showVersions = ParameterUtils.getBoolean(req.getParameter("showVersions"));
        try {
            calSearch = new CalendarSearchRequest(user, searchId, projectId, dateFieldName, startOffset, endOffset, new VersionDelegator(this.ofBizDelegator, this.versionManager), this.permissionManager, this.projectManager, this.searchRequestService, this.searchService, this.customFieldManager);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occcured creating ICal Calendar", (Throwable)e);
            return;
        }
        CalendarFactory factory = new CalendarFactory(calSearch, dateFieldName);
        Calendar calendar = factory.createICalendarFromSearch(showVersions);
        CalendarOutputter calWriter = new CalendarOutputter(true);
        res.setContentType("text/calendar");
        try {
            calWriter.output(calendar, res.getWriter());
        }
        catch (ValidationException ve) {
            LOG.error((Object)"ICalendarServlet.service(HttpServletRequest, HttpServletReponse) ValidationException encountered while writing calendar.", (Throwable)ve);
        }
    }
}

