/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ext.calendar;

import com.atlassian.jira.ext.calendar.model.GregorianCalendarFactory;
import com.atlassian.jira.project.browse.BrowseContext;
import java.util.Calendar;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class HtmlCalendarConfiguration {
    private static final Logger LOG = Logger.getLogger(HtmlCalendarConfiguration.class);
    private Long filterId;
    private Long projectId;
    private Calendar monthStart;
    private Long portletId;
    private String dateFieldName;
    private boolean displayVersions;
    private Long numOfIssueIcons;
    private String context;
    public static final String PROJECT_TAB_CONTEXT = "projectTab";
    private static final String START_DATE_VAR = "startDate";
    private static final String DISPLAY_VER_VAR = "displayVersions";
    private static final Long DEFAULT_NUM_ISSUES = 10L;

    public HtmlCalendarConfiguration(BrowseContext browseContext, HttpSession session) throws Exception {
        this(null, HtmlCalendarConfiguration.getProjId(browseContext), HtmlCalendarConfiguration.getBrowseMonth(session, HtmlCalendarConfiguration.getProjId(browseContext), PROJECT_TAB_CONTEXT), HtmlCalendarConfiguration.getProjId(browseContext), "duedate", HtmlCalendarConfiguration.getDisplayVersions(session, HtmlCalendarConfiguration.getProjId(browseContext), PROJECT_TAB_CONTEXT), DEFAULT_NUM_ISSUES, PROJECT_TAB_CONTEXT);
    }

    public HtmlCalendarConfiguration(Long searchId, Long projectId, Calendar monthStart, Long portletId, String dateFieldName, boolean showVersions, Long numOfIssueIcons, String context) {
        this.filterId = searchId;
        this.projectId = projectId;
        this.monthStart = null == monthStart ? HtmlCalendarConfiguration.getCurrentMonth() : monthStart;
        this.portletId = portletId;
        this.dateFieldName = dateFieldName;
        this.displayVersions = showVersions;
        this.numOfIssueIcons = numOfIssueIcons;
        this.context = context;
    }

    public static Calendar getCurrentMonth() {
        Calendar currentCal = GregorianCalendarFactory.constructCalendar();
        Calendar monthStartCal = GregorianCalendarFactory.constructCalendar();
        monthStartCal.set(currentCal.get(1), currentCal.get(2), monthStartCal.getMinimum(5));
        monthStartCal.set(9, 0);
        monthStartCal.set(10, monthStartCal.getMinimum(10));
        monthStartCal.set(12, monthStartCal.getMinimum(12));
        monthStartCal.set(13, monthStartCal.getMinimum(13));
        monthStartCal.set(14, monthStartCal.getMinimum(14));
        return monthStartCal;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Calendar getMonthStart() {
        return this.monthStart;
    }

    public Long getPortletId() {
        return this.portletId;
    }

    public String getDateFieldName() {
        return this.dateFieldName;
    }

    public boolean isDisplayVersions() {
        return this.displayVersions;
    }

    public Long getNumOfIssueIcons() {
        return this.numOfIssueIcons;
    }

    public static String getMonthSessionKey(Long key, String context, String variable) {
        return "com.atlassian.jira.ext.calendar." + context + "." + key + "." + variable;
    }

    public String getContext() {
        return this.context;
    }

    private static boolean getDisplayVersions(HttpSession sess, Long key, String context) {
        Boolean displayVersions = null;
        try {
            displayVersions = (Boolean)sess.getAttribute(HtmlCalendarConfiguration.getMonthSessionKey(key, context, DISPLAY_VER_VAR));
        }
        catch (Exception e) {
            LOG.error((Object)"HtmlCalendarConfiguration.getDisplayVersions(HttpSession, Long, String):boolean", (Throwable)e);
        }
        return displayVersions == null || displayVersions != false;
    }

    public static Calendar getBrowseMonth(HttpSession session, Long key, String context) {
        Calendar startMonthCal = null;
        try {
            startMonthCal = (Calendar)session.getAttribute(HtmlCalendarConfiguration.getMonthSessionKey(key, context, START_DATE_VAR));
        }
        catch (Exception e) {
            LOG.error((Object)"HtmlCalendarConfiguration.getBrowseMonth(HttpSession, Long, String):Calendar", (Throwable)e);
        }
        if (startMonthCal == null) {
            startMonthCal = HtmlCalendarConfiguration.getCurrentMonth();
        }
        return startMonthCal;
    }

    public static void setDisplayVersions(HttpSession session, Long key, boolean displayVersions, String context) {
        session.setAttribute(HtmlCalendarConfiguration.getMonthSessionKey(key, context, DISPLAY_VER_VAR), (Object)displayVersions);
    }

    public static void setBrowseMonth(HttpSession session, Long key, Calendar monthStartCal, String context) {
        session.setAttribute(HtmlCalendarConfiguration.getMonthSessionKey(key, context, START_DATE_VAR), (Object)monthStartCal);
    }

    private static Long getProjId(BrowseContext browseContext) throws Exception {
        return browseContext.getProject().getId();
    }
}

