(function () {

    JIRA.Auditing.SettingsController = function () {

        return {

            model: null,
            view: null,

            init: function () {
                this.model = new JIRA.Auditing.Settings();
                this.view = new JIRA.Auditing.SettingsView({ model: this.model });

                this.view.on("auditing:toggle-settings", this.toggleSettings, this);

                //fetch triggers 'change' when model differs from server response
                this.model.fetch();
            },

            toggleSettings: function (event) {
                this.model.save(
                    { "enabled": !event.isEnabled },
                    { type: 'put' }
                );
            }
        }
    }


    jQuery(function () {
        var settingsController = new JIRA.Auditing.SettingsController();
        settingsController.init();
    });
}());