(function($, Backbone) {

    JIRA.Auditing.RecordsView = Backbone.View.extend({

        el: ".auditing-table",

        events: {
            'click .show-details' : 'showDetails'
        },

        templates: {
            records: JIRA.Templates.Auditing.records,
            details: JIRA.Templates.Auditing.recordDetails,
            associatedItems: JIRA.Templates.Auditing.associatedItems,
            throbber: JIRA.Templates.Auditing.throbber
        },

        initialize: function() {
            this.$el.html(this.templates.records({ records: this.collection.toJSON() }));
        },

        showDetails: function(event) {
            var associatedItems,
                detailContainer,
                record,
                recordId;


            var target = AJS.$(event.target);
            var detailsWrapper = target.closest("tr").next();

            if (detailsWrapper.hasClass("hidden")) {

                recordId = parseInt(target.attr("data-id"), 10);
                record = this.collection.get(recordId).toJSON();

                detailContainer = detailsWrapper.find(".auditing-record-details");
                detailContainer.html(this.templates.details({ record: record }));

                //we need to get associated-items after they appear in DOM
                associatedItems = detailContainer.find(".associated-items");
                associatedItems.html(this.templates.associatedItems({ mappedItems: this._mapAssociatedItems(record) }));

                detailsWrapper.removeClass("hidden");
                target.text(AJS.I18n.getText("jap.view.see.less"));
            } else {
                detailsWrapper.addClass("hidden");
                target.text(AJS.I18n.getText("jap.view.see.more"));
            }
        },

        _mapAssociatedItems: function(record) {

            var items = {
                user: [],
                group: [],
                scheme: [],

                showDefaultMessage: true
            }

            _.each(record.associatedItems, function(item) {
                if (item.objectType && items[item.objectType.toLowerCase()]) {
                    items[item.objectType.toLowerCase()].push(item);
                }
            })

            items.showDefaultMessage = ((items.user.length + items.group.length + items.scheme.length) === 0) ? true : false;

            return items;
        }
    });

}(jQuery, Backbone));
