(function ($) {

    JIRA.Auditing.RecordsController = function() {

        return {

            collection: null,
            timeFilter: null,
            analytics: undefined,

            init: function() {
                new JIRA.FormDialog({
                    id: "export-data-dialog",
                    trigger: "#export-data"
                });

                $("#export-data").on('click', function() {
                    AJS.trigger('analyticsEvent', {name: 'administration.auditing.view.export.clicked', data: {}});
                });

                this.collection = new JIRA.Auditing.Records();
                var $auditing = $(".auditing-view-records");
                this.collection.paginator_ui.perPage = $auditing.data("perpage");
                this.collection.reset(this.collection.parse($auditing.data("records")));
                this.collection.bootstrap();

                new JIRA.Auditing.RecordsErrorsView({ collection : this.collection });
                new JIRA.Auditing.RecordsPagesView({ collection : this.collection });
                new JIRA.Auditing.SearchView({ collection : this.collection });

                this.timeFilter = JIRA.Auditing.TimeFilterController();
                this.timeFilter.init({ collection : this.collection });

                //initialize listeners
                this.collection.on("auditing:refresh-records", this.refreshRecords, this);

                //do not block leaving auditing page
                window.onbeforeunload = function() {};

                this.analytics = new JIRA.Auditing.RecordsAnalytics();
                this.analytics.init(this.collection, this.timeFilter.model);
            },

            refreshRecords: function (searchParams) {
                this.collection.filter = searchParams.filter || this.collection.filter;
                this.collection.timeUnit = searchParams.timeUnit || this.timeFilter.model.unit;
                this.collection.timeUnitValue = searchParams.timeUnitValue || this.timeFilter.model.unitValue;
                this.collection.fromDate = searchParams.fromDate || this.timeFilter.model.fromDate;
                this.collection.toDate = searchParams.toDate || this.timeFilter.model.toDate;
                this.analytics.searchStarted();
                this.collection.search();
            }
        }
    };

    jQuery(function() {
        var recordsController = JIRA.Auditing.RecordsController();
        recordsController.init();
    });
}(jQuery));
