(function($) {

    JIRA.Auditing.TimeFilterController = function() {

        return {

            model: {
                type: "all",
                unit: "minutes",
                unitValue: "",
                fromDate: "",
                toDate: ""
            },
            view: null,
            recordsCollections: null,

            init: function(args) {
                this.recordsCollections = args.collection;
                this.view = new JIRA.Auditing.TimeFilterView({model: this.model});

                this.view.on("auditing:update-time-filter-model", this.updateTimeFilterModel, this);
                this.view.render();
            },

            updateTimeFilterModel: function(event) {

                var splitFromVal,
                    splitToVal;

                //read radio
                this.model.type = $('input[name=auditDateFilter]:checked','#time-filter-form').val();
                //read input
                this._clearModel();

                if (this.model.type === this.view.consts.WITHIN_THE_LAST) {
                    this.model.unit = $('select.time-unit','#time-filter-form').val();
                    this.model.unitValue = $('input.time-unit-value','#time-filter-form').val();

                } else if (this.model.type === this.view.consts.BETWEEN) {
                    var splittedFrom = $('#from-date-picker').val().split("-");
                    this.model.fromDate = new Date(splittedFrom[0], splittedFrom[1]-1, splittedFrom[2]).getTime();

                    var splittedTo = $('#to-date-picker').val().split("-");
                    this.model.toDate = new Date(splittedTo[0], splittedTo[1]-1, splittedTo[2]).getTime();
                }

                this.view.updateFilterDescription();
                this.recordsCollections.trigger("auditing:refresh-records",
                    {
                        timeUnit: this.model.unit,
                        timeUnitValue: this.model.unitValue,
                        fromDate: this.model.fromDate,
                        toDate: this.model.toDate
                    }
                );
            },

            _clearModel: function() {
                this.model.unit = "";
                this.model.unitValue = "";
                this.model.fromDate = "";
                this.model.toDate = "";
            }

        }

    }

}(AJS.$));
