define('jira/admin-helper/permission-helper/ui', [
    'jquery',
    'jira/admin-helper/issue-picker',
    'jira/ajs/select/single-select',
    'jira/ajs/ajax/smart-ajax'
], function (
    $,
    IssuePicker,
    SingleSelect,
    SmartAjax
) {
    var permissions = WRM.data.claim('com.atlassian.jira.plugins.jira-admin-helper-plugin:permissions-provider.permissions-data');

    return {

        PERMISSIONS: permissions,
        initUi: function ($content, permissionContext, onContentAdded) {
            if (onContentAdded === undefined) {
                onContentAdded = $.noop;
            }

            initSingleSelects();

            var result = {};

            result.searchButton = $content.find("input.search");
            result.searchForm = $content.find("form.permissionhelper-search-form");
            var searcher = function (e) {
                e.preventDefault();

                var requestData = getRequestData($content, permissionContext);
                // Clear existing errors
                $content.find(".error").remove();
                // Check for errors
                var hasErrors = false;
                if (!requestData.params().issueKey) {
                    // No issue key provided
                    addFieldError($("#permissionhelper-issue", $content), AJS.I18n.getText("permissionhelper.dialog.issue.missing"));
                    hasErrors = true;
                }
                if (!requestData.params().permissionId) {
                    // No valid permission provided
                    addFieldError($("#permissionhelper-permission"), AJS.I18n.getText("permissionhelper.dialog.permission.missing"));
                    hasErrors = true;
                }
                if (hasErrors) {
                    return;
                }

                $content.find("#error-message-placeholder").empty();
                $content.find(".field-status-results").remove();
                $content.find(".field-status-placeholder").append($(JIRA.Templates.AdminHelper.Common.loadingStatus()));
                AJS.trigger('analyticsEvent', {
                    name: 'adminhelper.permhelper.check',
                    data: {permissionId: requestData.params().permissionId}
                });

                SmartAjax.makeRequest({
                    url: contextPath + AJS.format("/rest/whereismycf/1.0/permissions?username={0}&issueKey={1}&permissionKey={2}",
                        requestData.params().username, requestData.params().issueKey, requestData.params().permissionId),
                    complete: function (xhr, textStatus, smartAjaxResult) {
                        // remove the loading status
                        $content.find(".status-loading").remove();
                        if (smartAjaxResult.successful) {
                            // TODO may need to reset the dropdown fields
                            // instance.queryControl.$field.val("").css("color", "black");
                            var permissionInfo = smartAjaxResult.data;
                            var statusLines = processStatusLines(permissionInfo.statusLines);
                            var $results = $(JIRA.Templates.Dialogs.PermissionHelper.resultPage({
                                permissionName: permissionInfo.permissionName,
                                username: permissionInfo.username,
                                userDisplayName: permissionInfo.userDisplayName,
                                issueKey: permissionInfo.issueKey,
                                projectKey: permissionInfo.projectKey,
                                projectName: permissionInfo.projectName,
                                status: permissionInfo.status,
                                statusLines: statusLines,
                                hideFailedStatuses: shouldHideFailedStatuses(statusLines),
                                allFailedStatuses: !shouldHideFailedStatuses(statusLines),
                                allGreenStatuses: allGreenStatuses(statusLines),
                                baseUrl: contextPath,
                                permissionSchemeName: permissionInfo.permissionSchemeName
                            }));
                            $content.find(".field-status-placeholder").append($results);
                            onContentAdded();
                            $results.delegate(".show-failed-conditions", "click", function (e) {
                                e.preventDefault();
                                $(".statusRow[data-status='red']").removeClass('hidden');
                                $(".show-failed-conditions").hide();
                                $(".hide-failed-conditions").show();
                                onContentAdded();

                            });

                            $results.delegate(".hide-failed-conditions", "click", function (e) {
                                e.preventDefault();
                                $(".statusRow[data-status='red']").addClass('hidden');
                                $(".hide-failed-conditions").hide();
                                $(".show-failed-conditions").show();
                                onContentAdded()
                            });
                        } else {
                            handleError($content, smartAjaxResult);
                        }
                    }
                });
            };
            result.searchForm.submit(searcher);
            result.searchButton.click(searcher);

            function addFieldError($field, errorMsg) {
                $field.parent().append($("<div>")
                    .addClass("error")
                    .text(errorMsg));
            }

            function getRequestData($content, context) {
                return {
                    permissionId: function () {
                        var permissionId = $content.find("#permissionhelper-permission option:selected");
                        if (permissionId.length > 0) {
                            return permissionId.val();
                        } else {
                            // Permissions.BROWSE
                            return 10;
                        }
                    },

                    paramsForRequest: function () {
                        return context.asRequestParams(this._paramsFromContents());
                    },

                    params: function () {
                        return context.params(this._paramsFromContents());
                    },

                    _paramsFromContents: function () {
                        var fromContents = {};
                        var selectedUser = $content.find("#permissionhelper-user option:selected");
                        if (selectedUser.length == 1) {
                            fromContents.username = selectedUser.val();
                        } else {
                            fromContents.username = "";
                        }
                        var issueKey = $content.find("#permissionhelper-issue option:selected");
                        if (issueKey.length > 0) {
                            fromContents.issueKey = issueKey.val();
                        }
                        var permissionId = $content.find("#permissionhelper-permission option:selected");
                        if (permissionId.length > 0) {
                            fromContents.permissionId = permissionId.val();
                        }
                        return fromContents;
                    }

                }
            }

            function processStatusLines(statusLines) {
                if (statusLines.length == 0) {
                    return statusLines;
                }

                function processMessages(messages) {
                    var processedMsgs = [];
                    $.each(messages, function (index, message) {
                        processedMsgs.push(processMessage(message));
                    });
                    return processedMsgs;
                }

                function processMessage(message) {
                    if (message.parameters.length == 0) {
                        return AJS.escapeHTML(message.message);
                    } else {
                        var args = processParams(message.parameters);
                        // need to call AJS.format using apply cause all we have is an array of arguments
                        args.splice(0, 0, AJS.escapeHTML(message.message));
                        return AJS.format.apply(this, args);
                    }
                }

                function processParams(params) {
                    var result = [];
                    $.each(params, function (index, param) {
                        if (param.type == "plain") {
                            result.push(AJS.escapeHTML(param.value));
                        } else if (param.type == "link") {
                            result.push(AJS.format("<a href=''{0}'' target=''_blank''>{1}</a>", AJS.escapeHTML(param.href), AJS.escapeHTML(param.text)));
                        } else if (param.type == "newline") {
                            result.push("<br/>");
                        } else if (param.type == "tagstart") {
                            result.push("<" + param.tagName + ">");
                        } else if (param.type == "tagend") {
                            result.push("</" + param.tagName + ">");
                        } else {
                            throw "Unrecognized parameter type: " + param.type;
                        }
                    });
                    return result;
                }

                var processed = [];
                $.each(statusLines, function (index, statusLine) {
                    var newStatus = {};
                    newStatus.status = statusLine.status;
                    newStatus.required = statusLine.required;
                    newStatus.summary = processMessages(statusLine.summary);
                    newStatus.details = processMessages(statusLine.details);
                    processed.push(newStatus);
                });
                return processed;
            }

            function shouldHideFailedStatuses(statusLines) {
                var hasGreen = false;
                var hasFailedRequired = false;
                $.each(statusLines, function (index, statusLine) {
                    if (statusLine.status == "green") {
                        hasGreen = true;
                    }
                    else if (statusLine.required) {
                        hasFailedRequired = true;
                    }
                });

                return hasFailedRequired ? false : hasGreen;
            }

            function allGreenStatuses(statusLines) {
                var red = false;
                $.each(statusLines, function (index, statusLine) {
                    if (statusLine.status == "red") {
                        red = true;
                    }
                });
                return !red;
            }

            function handleError($contents, smartAjaxResult) {
                var errorsShown = false;
                var errorMessages = [];
                if (smartAjaxResult.data) {
                    var data = JSON.parse(smartAjaxResult.data);
                    if (data.errorMessages && data.errorMessages.length) {
                        errorMessages.push(data.errorMessages);
                        errorsShown = true;
                    }
                    if (data.errors) {
                        if (data.errors.issue) {
                            addFieldError($("#permissionhelper-issue", $contents), data.errors.issue);
                            errorsShown = true;
                        }
                        if (data.errors.user) {
                            addFieldError($("#permissionhelper-user", $contents), data.errors.user);
                            errorsShown = true;
                        }
                        if (data.errors.permission) {
                            addFieldError($("#permissionhelper-permission", $contents), data.errors.permission);
                            errorsShown = true;
                        }
                    }
                }
                if (!errorsShown) {
                    errorMessages.push(JIRA.SmartAjax.buildSimpleErrorContent(smartAjaxResult));
                }
                var $placeholder = result.searchForm.find("#error-message-placeholder");
                $.each(errorMessages, function (index, message) {
                    AJS.messages.error($placeholder, {
                        body: message,
                        closeable: false
                    });
                });
            }

            function initSingleSelects() {

                new IssuePicker({
                    element: $("#permissionhelper-issue"),
                    itemAttrDisplayed: "label",
                    width: 500
                });

                new SingleSelect({
                    element: $("#permissionhelper-permission"),
                    itemAttrDisplayed: "label", // show full text, not value, in lozenges. (e.g "Oyster Bay" instead of "5")
                    width: 500
                });
            }

            return result;
        }
    };
});
