define('jira/admin-helper/dialog', [
    'jquery',
    'jira/dialog/dialog',
    'jira/focus/set-focus'
], function (
    $,
    Dialog,
    setFocus
) {

    return Dialog.extend({

        _getDefaultOptions: function () {
            return $.extend(this._super(), {
                cached: false,
                widthClass: "large",
                stacked: true
            });
        },

        defineResources: function() {
            this._super();
            this.requireResource("com.atlassian.jira.plugins.jira-admin-helper-plugin:whereismycf-resources");
        },

        decorateContent: function () {

            var instance = this;

            // init the close link
            this.get$popupContent().find(".cancel").click(function (e) {
                instance.hide();
                e.preventDefault();
            });
        },

        _onShowContent: function () {
            this._super();
            if (Dialog.current === this) {
                var triggerConfig = new setFocus.FocusConfiguration();
                triggerConfig.context = this.get$popup()[0];
                triggerConfig.parentElementSelectors = ['.form-body'];
                setFocus.pushConfiguration(triggerConfig);
                setFocus.triggerFocus();
            }
        },

        hide: function (undim) {

            if (this._super(undim) === false) {
                return false;
            }
            setFocus.popConfiguration();
        }
    });
});