/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.context.DefaultPermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.inspector.engine.PermissionInspectionEngine;
import com.atlassian.jira.customfieldhelper.rest.FieldInfoRequestUserValidator;
import com.atlassian.jira.customfieldhelper.rest.InspectorFactory;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestException;
import com.atlassian.jira.customfieldhelper.rest.PermissionInfoJson;
import com.atlassian.jira.customfieldhelper.rest.PermissionRepresentation;
import com.atlassian.jira.customfieldhelper.rest.RestValidationHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="permissions")
@Produces(value={"application/json"})
public class PermissionsResource {
    private final FieldInfoRequestUserValidator userValidator;
    private final InspectorFactory inspectorFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory requestContextFactory;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionManager permissionManager;
    private final RestValidationHelper restValidationHelper;

    public PermissionsResource(FieldInfoRequestUserValidator userValidator, InspectorFactory inspectorFactory, JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory requestContextFactory, PermissionSchemeManager permissionSchemeManager, PermissionManager permissionManager, RestValidationHelper restValidationHelper) {
        this.userValidator = userValidator;
        this.inspectorFactory = inspectorFactory;
        this.authenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.restValidationHelper = restValidationHelper;
        this.requestContextFactory = requestContextFactory;
        this.permissionSchemeManager = permissionSchemeManager;
    }

    @GET
    public Response getUserInfoForIssue(@QueryParam(value="username") String username, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="permissionKey") String permissionKey) {
        try {
            this.userValidator.validateAndGet();
            ApplicationUser user = this.restValidationHelper.validateInspectedUser(username);
            Issue issue = this.restValidationHelper.validateIssue(issueKey);
            Project project = issue.getProjectObject();
            Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
            String permissionSchemeName = permissionScheme.getName();
            Option<ProjectPermission> optPermission = this.getPermissionFromKey(permissionKey);
            ProjectPermission permission = optPermission.isDefined() ? (ProjectPermission)optPermission.get() : (ProjectPermission)this.permissionManager.getProjectPermission(ProjectPermissions.BROWSE_PROJECTS).get();
            DefaultPermissionInspectionContext realContext = new DefaultPermissionInspectionContext(issue, issue.getProjectObject(), this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl(), user, this.authenticationContext.getI18nHelper(), permissionSchemeName, permission);
            Iterable<InspectionNote> result = new PermissionInspectionEngine((Iterable<? extends ProjectPermissionInspector>)this.inspectorFactory.getPermissionInspectors()).run(realContext);
            return Response.ok((Object)this.createOkResponse(result, realContext)).cacheControl(PermissionsResource.dontCache()).build();
        }
        catch (InvalidRequestException invalidRequest) {
            return invalidRequest.response();
        }
    }

    @GET
    @Path(value="/project")
    public Response getProjectPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (ProjectPermission permission : this.permissionManager.getAllProjectPermissions()) {
            permissions.add(new PermissionRepresentation(permission.getKey(), this.authenticationContext.getI18nHelper().getText(permission.getNameI18nKey())));
        }
        return Response.ok((Object)permissions).build();
    }

    private Option<ProjectPermission> getPermissionFromKey(String key) {
        return this.permissionManager.getProjectPermission(new ProjectPermissionKey(key));
    }

    private Object createOkResponse(Iterable<InspectionNote> notes, PermissionInspectionContext context) {
        return PermissionInfoJson.createInfoBean(notes, context);
    }

    private static javax.ws.rs.core.CacheControl dontCache() {
        return CacheControl.never();
    }
}

