/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.scheme.SchemeEntity;

public class SchemeSingleUserInspector
implements SchemeInspector {
    public static final SchemeSingleUserInspector INSTANCE = new SchemeSingleUserInspector();

    @Override
    public InspectionNote inspect(SchemeEntity schemeEntity, InspectionContext context) {
        if (context.isAnonymous()) {
            return InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.anonymous.cannot.meet")).build();
        }
        String userKey = schemeEntity.getParameter();
        if (userKey.equals(UserHelper.getUserKey(context))) {
            return InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.singleuser.ok").addPlainParameter(UserHelper.getDisplayName(context)).build()).build();
        }
        return null;
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.singleuser.summary");
    }
}

